
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: DisplayScreen.m,v 1.2 1999/06/06 20:25:59 stes Exp $
 */

#include "DisplayScreen.h"

id Display;

@implementation DisplayScreen 

/* display box access */

+ boundingBox { [self notImplemented]; }
+ actualScreenSize { [self notImplemented]; }
+ startUp { [self notImplemented]; }
+ shutDown { [self notImplemented]; }

/* displaying */

- copyBits:srcRect from:srcForm at:dstOrigin clippingBox:clipRect rule:(int)rule fillColor:aForm { [self notImplemented]; }
- flash:aRect { [self notImplemented]; }

/* other */

- boundingBox { [self notImplemented]; }
- clippingTo:aRect do:aBlock { [self notImplemented]; }
- deferUpdates:(BOOL)aBoolean { [self notImplemented]; }
- forceDisplayUpdate { [self notImplemented]; }
- forceToScreen { [self notImplemented]; }
- forceToScreen:aRect { [self notImplemented]; }
- fullBoundingBox { [self notImplemented]; }
- fullScreen { [self notImplemented]; }
- (int)width { [self notImplemented]; }
- (int)height { [self notImplemented]; }
- newDepth:(int)bps { [self notImplemented]; }
- replacedBy:aForm do:aBlock { [self notImplemented]; }
- restoreAfter:aBlock { [self notImplemented]; }
- usableArea { [self notImplemented]; }

/* private */

- beDisplay { [self notImplemented]; }
- copyFrom:aForm { [self notImplemented]; }
- newDepthNoRestore:(int)bps { [self notImplemented]; }
- setExtent:e depth:(int)bps { [self notImplemented]; }

@end
 
