
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: DisplayScreen.h,v 1.2 1999/06/06 20:25:59 stes Exp $
 */

#ifndef __DISPLAYSCREEN_H__

#include <Form.h>

extern id Display;

@interface DisplayScreen : Form
{
  id clippingBox;
}

/* display box access */

+ boundingBox;
+ actualScreenSize;
+ startUp;
+ shutDown;

/* displaying */

- copyBits:srcRect from:srcForm at:dstOrigin clippingBox:clipRect rule:(int)rule fillColor:aForm;
- flash:aRect;

/* other */

- boundingBox;
- clippingTo:aRect do:aBlock;
- deferUpdates:(BOOL)aBoolean;
- forceDisplayUpdate;
- forceToScreen;
- forceToScreen:aRect;
- fullBoundingBox;
- fullScreen;
- (int)width;
- (int)height;
- newDepth:(int)bps;
- replacedBy:aForm do:aBlock;
- restoreAfter:aBlock;
- usableArea;

/* private */

- beDisplay;
- copyFrom:aForm;
- newDepthNoRestore:(int)bps;
- setExtent:e depth:(int)bps;

@end
 
#define __DISPLAYSCREEN_H__
#endif

