
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: DisplayObject.m,v 1.1 1999/06/05 16:03:25 stes Exp $
 */

#include "DisplayObject.h"

@implementation DisplayObject

/* accessing */

- extent { [self notImplemented]; }
- (int)height { [self notImplemented]; }
- offset { [self notImplemented]; }
- offset:pt { [self notImplemented]; }
- relativeRectangle { [self notImplemented]; }
- (int)width { [self notImplemented]; }

/* truncation */

- rounded { [self notImplemented]; }

/* transforming */

- align:pt with:rpt { [self notImplemented]; }
- scaleBy:pt { [self notImplemented]; }
- translateBy:pt { [self notImplemented]; }

/* display box access */

- boundingBox { [self notImplemented]; }
- center { [self notImplemented]; }
- computeBoundingBox { [self notImplemented]; }
- initialExtent { [self notImplemented]; }

/* displaying */

- displayAt:pt { [self notImplemented]; }
- displayOn:medium { [self notImplemented]; }
- displayOn:medium at:pt { [self notImplemented]; }
- displayOn:medium at:pt clippingBox:clipRect { [self notImplemented]; }
- displayOn:medium at:pt clippingBox:clipRect rule:(int)r fillColor:fc { [self notImplemented]; }
- displayOn:medium at:pt rule:(int)r { [self notImplemented]; }
- displayOn:medium transformation:tf clippingBox:clipRect { [self notImplemented]; }

/* displaying */

- display { [self notImplemented]; }
- follow:locBlock while:durBlock { [self notImplemented]; }
- follow:locBlock while:durBlock bitsBehind:initialBits startingLoc:loc { [self notImplemented]; }
- (BOOL)isTransparent { [self notImplemented]; }
- slideFrom:startpoint to:stoppoint nSteps:(int)nsteps { [self notImplemented]; }
- slideFrom:startpoint to:stoppoint nSteps:(int)nsteps delay:(int)msecs { [self notImplemented]; }

@end
 
