
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: DisplayMedium.m,v 1.1 1999/06/05 16:03:25 stes Exp $
 */

#include "DisplayMedium.h"

@implementation DisplayMedium

/* displaying */

- copyBits:srcRect from:srcForm at:dstOrigin clippingBox:clipRect rule:(int)rule fillColor:aForm { [self notImplemented]; }
- drawLine:srcForm from:beginPoint to:endPoint clippingBox:clipRect rule:(int)rule fillColor:aForm { [self notImplemented]; }

/* coloring */

- fill:aRect fillColor:aForm { [self notImplemented]; }
- fill:aRect rule:(int)rule fillColor:aForm { [self notImplemented]; }
- fillBlack { [self notImplemented]; }
- fillBlack:aRect { [self notImplemented]; }
- fillColor:aColor { [self notImplemented]; }
- fillGray { [self notImplemented]; }
- fillGray:aRect { [self notImplemented]; }
- fillShape:aForm fillColor:aColor { [self notImplemented]; }
- fillShape:aForm fillColor:aColor at:location { [self notImplemented]; }
- fillWhite { [self notImplemented]; }
- fillWhite:aRect { [self notImplemented]; }
- fillWithColor:aColor { [self notImplemented]; }
- reverse { [self notImplemented]; }
- reverse:aRect { [self notImplemented]; }
- reverse:aRect fillColor:aForm { [self notImplemented]; }

/* bordering */

- (int)borderWidth { [self notImplemented]; }
- borderWidth:(int)w { [self notImplemented]; }
- border:rect width:(int)w { [self notImplemented]; }
- border:rect width:(int)w fillColor:fc { [self notImplemented]; }
- border:rect width:(int)w rule:(int)r fillColor:fillColor { [self notImplemented]; }

@end
 
