
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Cursor.h,v 1.1 1999/06/05 16:03:25 stes Exp $
 */

#ifndef __CURSOR_H__

#include <Form.h>

@interface Cursor : Form
{
}

/* class initialization */

+ initialize;

/* instance creation */

+ new;
+ blank;
+ bottomLeft;
+ bottomRight;
+ corner;
+ crossHair;
+ down;
+ execute;
+ marker;
+ menu;
+ move;
+ normal;
+ origin;
+ read;
+ rightArrow;
+ square;
+ topLeft;
+ topRight;
+ up;
+ wait;
+ webLink;
+ write;

/* current cursor */

+ currentCursor;
+ currentCursor:aCursor;

/* updating */

- changed:param;

/* displaying */

- beCursor;
- show;
- showGridded:gridpoint;
- showWhile:aBlock;

/* testing */

- (BOOL)hasMask;

/* printing */

- printOn:(IOD)iod;

/* converting */

- asCursorForm;
- withMask;

@end
 
#define __CURSOR_H__
#endif

