
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Color.m,v 1.1 1999/06/05 16:03:25 stes Exp $
 */

#include "Color.h"

@implementation Color

/* instance creation */

+ new
{
  return [self r:0 g:0 b:0];
}

+ r:(float)r g:(float)g b:(float)b
{
  return [[super new] setRed:r green:b blue:b];
}

/* class initialization */

+ initialize { }

/* examples */

+ showColors:colorList { [self notImplemented]; }

/* named colors */

#define defcolor(cname,Cname,x,y,z)\
static id Cname;\
\
+ cname\
{\
  if (!Cname) Cname = [self r:x g:y b:z];\
  return Cname;\
}\
\

defcolor(black,Black,0,0,0)
defcolor(veryVeryDarkGray,VeryVeryDarkGray,0.125,0.125,0.125)
defcolor(veryDarkGray,VeryDarkGray,0.25,0.25,0.25)
defcolor(darkGray,DarkGray,0.375,0.375,0.375)
defcolor(gray,Gray,0.5,0.5,0.5)
defcolor(lightGray,LightGray,0.625,0.625,0.625)
defcolor(veryLightGray,VeryLightGray,0.75,0.75,0.75)
defcolor(veryVeryLightGray,VeryVeryLightGray,0.875,0.875,0.875)
defcolor(white,White,1,1,1)
defcolor(red,Red,1,0,0)
defcolor(yellow,Yellow,1,1,0)
defcolor(green,Green,0,1,0)
defcolor(cyan,Cyan,0,1,1)
defcolor(blue,Blue,0,0,1)
defcolor(magenta,Magenta,1,0,1)
defcolor(brown,Brown,0.6,0.2,0)
defcolor(orange,Orange,1,0.6,0)
defcolor(lightRed,LightRed,1,0.8,0.8)
defcolor(lightYellow,LightYellow,1,1,0.8)
defcolor(lightGreen,LightGreen,0.8,1,0.6)
defcolor(lightCyan,LightCyan,0.4,1,1)
defcolor(lightBlue,LightBlue,0.8,1,1)
defcolor(lightMagenta,LightMagenta,1,0.8,1)
defcolor(lightBrown,LightBrown,1,0.6,0.2)
defcolor(lightOrange,LightOrange,1,0.8,0.4)
defcolor(tan,Tan,0.8,0.8,0.5) /* ? */

+ transparent { [self notImplemented]; }

/* color map */

/* color from user */

+ fromUser { [self notImplemented]; }

/* other class methods */

+ colorNames { [self notImplemented]; }
+ indexedColors { [self notImplemented]; }
+ shutdown { [self notImplemented]; }

/* access */

- alpha { [self notImplemented]; }
- (float)redComponent { [self notImplemented]; }
- (float)blueComponent { [self notImplemented]; }
- (float)greenComponent { [self notImplemented]; }
- brightness { [self notImplemented]; }
- hue { [self notImplemented]; }
- luminance { [self notImplemented]; }

/* equality */

- (BOOL)isEqual:x { return NO; }
- (unsigned)hash { return (((unsigned)(red * 1024)) << 10) + (((unsigned)(green * 1024)) << 5) + (unsigned)(blue * 1024); }

/* queries */

- (BOOL)isBitmapFill { [self notImplemented]; }
- (BOOL)isBlack { [self notImplemented]; }
- (BOOL)isColor { [self notImplemented]; }
- (BOOL)isGray { [self notImplemented]; }
- (BOOL)isSolidFill { [self notImplemented]; }
- (BOOL)isTranslucent { [self notImplemented]; }
- (BOOL)isTranslucentColor { [self notImplemented]; }
- (BOOL)isTransparent { [self notImplemented]; }

/* transformations */

- muchLighter { [self notImplemented]; }
- slightlyDarker { [self notImplemented]; }
- slightlyLighter { [self notImplemented]; }
- veryMuchLighter { [self notImplemented]; }

/* group of shades */

- darkShades:(int)num { [self notImplemented]; }
- lightShades:(int)num { [self notImplemented]; }
- mix:color2 shades:(int)num { [self notImplemented]; }
- wheel:(int)num { [self notImplemented]; }

/* printing */

- printOn:(IOD)iod { [self notImplemented]; }
- shortPrintString { [self notImplemented]; }

/* other */

- colorForInsets { [self notImplemented]; }
- display { [self notImplemented]; }
- (STR)name { [self notImplemented]; }
- newTileMorphRepresentative { [self notImplemented]; }
- rgbTriplet { [self notImplemented]; }

/* conversions */

- asColor { [self notImplemented]; }
- dominantColor { [self notImplemented]; }

/* private */

- attemptToMutateError { [self notImplemented]; }
- flushCache { [self notImplemented]; }
- privateAlpha { [self notImplemented]; }
- privateBlue { [self notImplemented]; }
- privateGreen { [self notImplemented]; }
- privateRGB { [self notImplemented]; }
- privateRed { [self notImplemented]; }

- setRed:(float)r green:(float)g blue:(float)b 
{
  red = r;
  green = g;
  blue = b;
  return self;
}

/* copying */

- veryDeepCopyWith:deepCopier { [self notImplemented]; } 

@end
 
