
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: Color.h,v 1.1 1999/06/05 16:03:25 stes Exp $
 */

#ifndef __COLOR_H__

#include <Object.h>

@interface Color : Object
{
  float red;
  float green;
  float blue;
}

/* instance creation */

+ new;
+ r:(float)r g:(float)g b:(float)b;

/* class initialization */

+ initialize;

/* examples */

+ showColors:colorList;

/* named colors */

+ black;
+ blue;
+ brown;
+ cyan;
+ darkGray;
+ gray;
+ green;
+ lightBlue;
+ lightCyan;
+ lightGray;
+ lightGreen;
+ lightMagenta;
+ lightOrange;
+ lightRed;
+ lightYellow;
+ magenta;
+ orange;
+ red;
+ tan;
+ transparent;
+ veryDarkGray;
+ veryLightGray;
+ veryVeryDarkGray;
+ veryVeryLightGray;
+ white;
+ yellow;

/* color map */

/* color from user */

+ fromUser;

/* other class methods */

+ colorNames;
+ indexedColors;
+ shutdown;

/* access */

- alpha;
- (float)redComponent;
- (float)blueComponent;
- (float)greenComponent;
- brightness;
- hue;
- luminance;

/* equality */

- (BOOL)isEqual:x;
- (unsigned)hash;

/* queries */

- (BOOL)isBitmapFill;
- (BOOL)isBlack;
- (BOOL)isColor;
- (BOOL)isGray;
- (BOOL)isSolidFill;
- (BOOL)isTranslucent;
- (BOOL)isTranslucentColor;
- (BOOL)isTransparent;

/* transformations */

- muchLighter;
- slightlyDarker;
- slightlyLighter;
- veryMuchLighter;

/* group of shades */

- darkShades:(int)num;
- lightShades:(int)num;
- mix:color2 shades:(int)num;
- wheel:(int)num;

/* printing */

- printOn:(IOD)iod;
- shortPrintString;

/* other */

- colorForInsets;
- display;
- (STR)name;
- newTileMorphRepresentative;
- rgbTriplet;

/* conversions */

- asColor;
- dominantColor;

/* private */

- attemptToMutateError;
- flushCache;
- privateAlpha;
- privateBlue;
- privateGreen;
- privateRGB;
- privateRed;
- setRed:(float)r green:(float)g blue:(float)b;

/* copying */

- veryDeepCopyWith:deepCopier; 

@end
 
#define __COLOR_H__
#endif

