
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: BookMorph.m,v 1.3 1999/05/26 18:05:32 stes Exp $
 */

#include "BookMorph.h"

@implementation BookMorph

/* class methods */

+ alreadyInFromUrl:aUrl { [self notImplemented]; }
+ authoringPrototype { [self notImplemented]; }
+ grabURL:aUrl { [self notImplemented]; }
+ (BOOL)isInWorld:aWorld withUrl:aUrl { [self notImplemented]; }

/* initialization */

- closeCurrentPageToDragNDrop { [self notImplemented]; }
- fromRemoteStream:strm { [self notImplemented]; }
- fromURL:url { [self notImplemented]; }
- initialize { [self notImplemented]; }
- newPages:pageList { [self notImplemented]; }
- newPages:pageList currentIndex:index { [self notImplemented]; }
- removeEverything { [self notImplemented]; }
- setInitialState { [self notImplemented]; }

/* sorting */

- acceptSortedContentsFrom:aHolder { [self notImplemented]; }
- morphsForPageSorter { [self notImplemented]; }
- sortPages { [self notImplemented]; }
- sortPages:evt { [self notImplemented]; }

/* accessing */

- allNonSubmorphMorphs { [self notImplemented]; }
- currentPage { [self notImplemented]; }
- pageNamed:aName { [self notImplemented]; }
- pageNumberOf:aMorph { [self notImplemented]; }
- pages { [self notImplemented]; }
- pages:aMorphList { [self notImplemented]; }
- userString { [self notImplemented]; }

/* dropping & grabbing */

- acceptDroppingMorph:aMorph event:evt { [self notImplemented]; }
- (BOOL)allowSubmorphExtraction { [self notImplemented]; }
- rootForGrabOf:aMorph { [self notImplemented]; }
- (BOOL)wantsDroppedMorph:aMorph event:evt { [self notImplemented]; }

/* insert & delete */

- deletePage { [self notImplemented]; }
- deletePageBasic { [self notImplemented]; }
- insertPage:aPage pageSize:aPageSize { [self notImplemented]; }
- insertPage:aPage pageSize:aPageSize atIndex:anIndex { [self notImplemented]; }
- insertPageColored:aColor { [self notImplemented]; }
- insertPageLabel:labelString morphs:morphList { [self notImplemented]; }
- insertPageShowingString:aString fontName:aName fontSize:aSize { [self notImplemented]; }
- insertPageShowingString:aString usingFont:aFont { [self notImplemented]; }
- insertPageSilentlyAtEnd { [self notImplemented]; }

/* navigation */

- goToPage:pageNumber { [self notImplemented]; }
- goToPage:pageNumber transitionSpec:transitionSpec { [self notImplemented]; }
- goToPageMorph:aMorph { [self notImplemented]; }
- goToPageMorph:aMorph fromBookmark:aBookmark { [self notImplemented]; }
- goToPageMorphNamed:aName { [self notImplemented]; }
- goToPageUrl:aUrl { [self notImplemented]; }
- goto:aPlayer { [self notImplemented]; }
- lastPage { [self notImplemented]; }
- nextPage { [self notImplemented]; }
- pageNumber { [self notImplemented]; }
- previousPage { [self notImplemented]; }
- setWrapPages:(BOOL)doWrap { [self notImplemented]; }
- showMoreControls { [self notImplemented]; }
- transitionSpecFor:aMorph { [self notImplemented]; }

/* menu */

- addBookMenuItemsTo:aMenu hand:aHandMorph { [self notImplemented]; }
- bookmarkForThisPage { [self notImplemented]; }
- copyUrl { [self notImplemented]; }
- findText:wants { [self notImplemented]; }
- findText:keys inStrings:rawStrings startAt:startIndex container:oldContainer pageNum:pageNum { [self notImplemented]; }
- forgetUrls { [self notImplemented]; }
- getAllText { [self notImplemented]; }
- getStemUrl { [self notImplemented]; }
- highlightText:stringToHilite at:index in:insideOf { [self notImplemented]; }
- invokeBookMenu { [self notImplemented]; }
- keepTogether { [self notImplemented]; }
- makeUniformPageSize { [self notImplemented]; }
- menuPageSoundFor:target event:evt { [self notImplemented]; }
- menuPageSoundForAll:evt { [self notImplemented]; }
- menuPageSoundForThisPage:evt { [self notImplemented]; }
- menuPageVisualFor:target event:evt { [self notImplemented]; }
- menuPageVisualForAll:evt { [self notImplemented]; }
- menuPageVisualForThisPage:evt { [self notImplemented]; }
- newTextMorph { [self notImplemented]; }
- pasteBookPage { [self notImplemented]; }
- reload { [self notImplemented]; }
- reserveUrls { [self notImplemented]; }
- reserveUrlsIfNeeded { [self notImplemented]; }
- saveAsNumberedURLs { [self notImplemented]; }
- saveIndexOfOnly:aPage { [self notImplemented]; }
- saveIndexOnURL { [self notImplemented]; }
- saveOnUrlPage:pageMorph { [self notImplemented]; }
- saveOneOnURL { [self notImplemented]; }
- savePagesOnURL { [self notImplemented]; }
- setNewPagePrototype { [self notImplemented]; }
- textSearch { [self notImplemented]; }
- thumbnailForThisPage { [self notImplemented]; }
- uncachePageSorter { [self notImplemented]; }

/* copying */

- copyRecordingIn:dict { [self notImplemented]; }
- updateReferencesUsing:dict { [self notImplemented]; }

/* other */

- abandon { [self notImplemented]; }
- configureForKids { [self notImplemented]; }
- makeMinimalControlsWithColor:aColor title:aString { [self notImplemented]; }
- releaseCachedState { [self notImplemented]; }
- resizePagesTo:anExtent { [self notImplemented]; }
- succeededInRevealing:aPlayer { [self notImplemented]; }
- wrappedInPartsWindowWithTitle:aTitle { [self notImplemented]; }

@end
 
