
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: BookMorph.h,v 1.3 1999/05/26 18:05:32 stes Exp $
 */

#ifndef __BOOKMORPH_H__

#include <BooklikeMorph.h>

@interface BookMorph : BooklikeMorph
{
	id pages;
	id currentPage;
}

/* class methods */

+ alreadyInFromUrl:aUrl;
+ authoringPrototype;
+ grabURL:aUrl;
+ (BOOL)isInWorld:aWorld withUrl:aUrl;

/* initialization */

- closeCurrentPageToDragNDrop;
- fromRemoteStream:strm;
- fromURL:url;
- initialize;
- newPages:pageList;
- newPages:pageList currentIndex:index;
- removeEverything;
- setInitialState;

/* sorting */

- acceptSortedContentsFrom:aHolder;
- morphsForPageSorter;
- sortPages;
- sortPages:evt;

/* accessing */

- allNonSubmorphMorphs;
- currentPage;
- pageNamed:aName;
- pageNumberOf:aMorph;
- pages;
- pages:aMorphList;
- userString;

/* dropping & grabbing */

- acceptDroppingMorph:aMorph event:evt;
- (BOOL)allowSubmorphExtraction;
- rootForGrabOf:aMorph;
- (BOOL)wantsDroppedMorph:aMorph event:evt;

/* insert & delete */

- deletePage;
- deletePageBasic;
- insertPage:aPage pageSize:aPageSize;
- insertPage:aPage pageSize:aPageSize atIndex:anIndex;
- insertPageColored:aColor;
- insertPageLabel:labelString morphs:morphList;
- insertPageShowingString:aString fontName:aName fontSize:aSize;
- insertPageShowingString:aString usingFont:aFont;
- insertPageSilentlyAtEnd;

/* navigation */

- goToPage:pageNumber;
- goToPage:pageNumber transitionSpec:transitionSpec;
- goToPageMorph:aMorph;
- goToPageMorph:aMorph fromBookmark:aBookmark;
- goToPageMorphNamed:aName;
- goToPageUrl:aUrl;
- goto:aPlayer;
- lastPage;
- nextPage;
- pageNumber;
- previousPage;
- setWrapPages:(BOOL)doWrap;
- showMoreControls;
- transitionSpecFor:aMorph;

/* menu */

- addBookMenuItemsTo:aMenu hand:aHandMorph;
- bookmarkForThisPage;
- copyUrl;
- findText:wants;
- findText:keys inStrings:rawStrings startAt:startIndex container:oldContainer pageNum:pageNum;
- forgetUrls;
- getAllText;
- getStemUrl;
- highlightText:stringToHilite at:index in:insideOf;
- invokeBookMenu;
- keepTogether;
- makeUniformPageSize;
- menuPageSoundFor:target event:evt;
- menuPageSoundForAll:evt;
- menuPageSoundForThisPage:evt;
- menuPageVisualFor:target event:evt;
- menuPageVisualForAll:evt;
- menuPageVisualForThisPage:evt;
- newTextMorph;
- pasteBookPage;
- reload;
- reserveUrls;
- reserveUrlsIfNeeded;
- saveAsNumberedURLs;
- saveIndexOfOnly:aPage;
- saveIndexOnURL;
- saveOnUrlPage:pageMorph;
- saveOneOnURL;
- savePagesOnURL;
- setNewPagePrototype;
- textSearch;
- thumbnailForThisPage;
- uncachePageSorter;

/* copying */

- copyRecordingIn:dict;
- updateReferencesUsing:dict;

/* other */

- abandon;
- configureForKids;
- makeMinimalControlsWithColor:aColor title:aString;
- releaseCachedState;
- resizePagesTo:anExtent;
- succeededInRevealing:aPlayer;
- wrappedInPartsWindowWithTitle:aTitle;

@end
 
#define __BOOKMORPH_H__
#endif

