
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: TransformationMorph.m,v 1.2 1999/05/25 20:45:57 stes Exp $
 */

#include "TransformationMorph.h"

@implementation TransformationMorph

/* initialization */

- asFlexOf:aMorph { [self notImplemented]; }
- flexing:aMorph byTransformation:tfm { [self notImplemented]; }

/* accessing */

- extent:anExtent { [self notImplemented]; }
- forwardDirection { [self notImplemented]; }
- (BOOL)hasNoScaleOrRotation { [self notImplemented]; }
- innocuousName { [self notImplemented]; }
- (BOOL)isFlexMorph { [self notImplemented]; }
- (BOOL)isRenderer { [self notImplemented]; }
- printOn:(IOD)iod { [self notImplemented]; }
- referencePosition { [self notImplemented]; }
- referencePosition:aPoint { [self notImplemented]; }
- rotationDegrees { [self notImplemented]; }
- rotationDegrees:degrees { [self notImplemented]; }
- scaleToFit:anExtent { [self notImplemented]; }

/* drawing */

- drawOn:aCanvas { [self notImplemented]; }

/* change reporting */

- layoutChanged { [self notImplemented]; }

/* menu */

- removeFlexShell { [self notImplemented]; }

/* private */

- adjustAfter:changeBlock { [self notImplemented]; }
- chooseSmoothing { [self notImplemented]; }

@end

