
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: TransformMorph.m,v 1.2 1999/05/25 20:40:44 stes Exp $
 */

#include "TransformMorph.h"

@implementation TransformMorph

/* initialization */

- initialize { [self notImplemented]; }

/* accessing */

- angle { [self notImplemented]; }
- angle:newAngle { [self notImplemented]; }
- offset { [self notImplemented]; }
- offset:newOffset { [self notImplemented]; }
- scale { [self notImplemented]; }
- scale:newScale { [self notImplemented]; }
- setOffset:newOffset angle:newAngle scale:newScale { [self notImplemented]; }
- smoothing:cellSize { [self notImplemented]; }
- smoothingOff { [self notImplemented]; }
- smoothingOn { [self notImplemented]; }

/* submorphs access */

- morphsAt:atPoint addTo:mList { [self notImplemented]; }
- unlockedMorphsAt:atPoint addTo:mList { [self notImplemented]; }

/* drawing */

- canvasForSubmorphs:canvasForMe { [self notImplemented]; }
- colorForInsets { [self notImplemented]; }
- fullDrawOn:aCanvas { [self notImplemented]; }
- fullDrawOn:aCanvas without:stopMorph andStopThere:stopThere { [self notImplemented]; }

/* geometry */

- (BOOL)containsPoint:aPoint { [self notImplemented]; }
- fullBounds { [self notImplemented]; }
- privateFullMoveBy:delta { [self notImplemented]; }
- submorphBounds { [self notImplemented]; }

/* change reporting */

- changed { [self notImplemented]; }
- invalidRect:invalidRect { [self notImplemented]; }

/* events */

- transformFrom:uberMorph { [self notImplemented]; }

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph { [self notImplemented]; }

@end

