
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: TransformMorph.h,v 1.2 1999/05/25 20:40:44 stes Exp $
 */

#ifndef __TRANSFORMMORPH_H__

#include <Morph.h>

@interface TransformMorph : Morph
{
	id transform;
	id smoothing;
}

/* initialization */

- initialize;

/* accessing */

- angle;
- angle:newAngle;
- offset;
- offset:newOffset;
- scale;
- scale:newScale;
- setOffset:newOffset angle:newAngle scale:newScale;
- smoothing:cellSize;
- smoothingOff;
- smoothingOn;

/* submorphs access */

- morphsAt:atPoint addTo:mList;
- unlockedMorphsAt:atPoint addTo:mList;

/* drawing */

- canvasForSubmorphs:canvasForMe;
- colorForInsets;
- fullDrawOn:aCanvas;
- fullDrawOn:aCanvas without:stopMorph andStopThere:stopThere;

/* geometry */

- (BOOL)containsPoint:aPoint;
- fullBounds;
- privateFullMoveBy:delta;
- submorphBounds;

/* change reporting */

- changed;
- invalidRect:invalidRect;

/* events */

- transformFrom:uberMorph;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;

@end
 
#define __TRANSFORMMORPH_H__
#endif

