
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: TextMorph.m,v 1.4 1999/05/29 13:47:25 stes Exp $
 */

#include "TextMorph.h"

@implementation TextMorph

/* class methods */

+ authoringPrototype { [self notImplemented]; }
+ initialize { }

/* initialization */

- beAllFont:aFont { [self notImplemented]; }
- configureForKids { [self notImplemented]; }
- copy { [self notImplemented]; }
- initialize { [self notImplemented]; }
- releaseCachedState { [self notImplemented]; }
- string:aString fontName:aName size:aSize { [self notImplemented]; }

/* accessing */

- asText { [self notImplemented]; }
- contents { [self notImplemented]; }
- contents:stringOrText { [self notImplemented]; }
- contents:stringOrText wrappedTo:width { [self notImplemented]; }
- contentsAsIs:stringOrText { [self notImplemented]; }
- contentsWrapped:stringOrText { [self notImplemented]; }
- copyRecordingIn:dict { [self notImplemented]; }
- editor { [self notImplemented]; }
- newContents:stringOrText { [self notImplemented]; }
- userString { [self notImplemented]; }

/* alignment */

- centered { [self notImplemented]; }
- justified { [self notImplemented]; }
- leftFlush { [self notImplemented]; }
- rightFlush { [self notImplemented]; }

/* drawing */

- drawBoundsOn:aCanvas { [self notImplemented]; }
- drawNullTextOn:aCanvas { [self notImplemented]; }
- drawOn:aCanvas { [self notImplemented]; }

/* editing */

- acceptContents { [self notImplemented]; }
- cancelEdits { [self notImplemented]; }
- chooseAlignment { [self notImplemented]; }
- chooseEmphasis { [self notImplemented]; }
- chooseFont { [self notImplemented]; }
- chooseStyle { [self notImplemented]; }
- clearTypeIn { [self notImplemented]; }
- handleEdit:editBlock { [self notImplemented]; }
- handleInteraction:interactionBlock fromEvent:evt { [self notImplemented]; }
- (BOOL)handlesMouseDown:evt { [self notImplemented]; }
- (BOOL)hasFocus { [self notImplemented]; }
- (BOOL)hasUnacceptedEdits:(BOOL)aBoolean { [self notImplemented]; }
- keyStroke:evt { [self notImplemented]; }
- keyboardFocusChange:(BOOL)aBoolean { [self notImplemented]; }
- mouseDown:evt { [self notImplemented]; }
- mouseMove:evt { [self notImplemented]; }
- mouseUp:evt { [self notImplemented]; }
- passKeyboardFocusTo:otherMorph { [self notImplemented]; }
- xeqLinkText:sourceString withParameter:param { [self notImplemented]; }

/* printing */

- fullPrintOn:(IOD)iod { [self notImplemented]; }

/* geometry */

- bounds { [self notImplemented]; }
- container { [self notImplemented]; }
- (BOOL)containsPoint:aPoint { [self notImplemented]; }
- defaultLineHeight { [self notImplemented]; }
- extent:anExtent { [self notImplemented]; }
- goBehind { [self notImplemented]; }
- layoutChanged { [self notImplemented]; }
- privateMoveBy:delta { [self notImplemented]; }
- textBounds { [self notImplemented]; }

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph { [self notImplemented]; }
- addOptionalHandlesTo:aHalo box:box { [self notImplemented]; }
- followCurve { [self notImplemented]; }
- reverseCurveDirection { [self notImplemented]; }
- setCurveBaseline:evt { [self notImplemented]; }

/* linked frames */

- addPredecessor:evt { [self notImplemented]; }
- addSuccessor:evt { [self notImplemented]; }
- firstCharacterIndex { [self notImplemented]; }
- firstInChain { [self notImplemented]; }
- (BOOL)isLinkedTo:aMorph { [self notImplemented]; }
- lastCharacterIndex { [self notImplemented]; }
- predecessor { [self notImplemented]; }
- recomposeChain { [self notImplemented]; }
- startingIndex { [self notImplemented]; }
- successor { [self notImplemented]; }
- withSuccessorsDo:aBlock { [self notImplemented]; }

/* private */

- adjustLineIndicesBy:delta { [self notImplemented]; }
- delete { [self notImplemented]; }
- fit { [self notImplemented]; }
- installEditor { [self notImplemented]; }
- installEditorToReplace:priorEditor { [self notImplemented]; }
- loadCachedState { [self notImplemented]; }
- paragraph { [self notImplemented]; }
- paragraphClass { [self notImplemented]; }
- predecessorChanged { [self notImplemented]; }
- releaseEditor { [self notImplemented]; }
- releaseParagraph { [self notImplemented]; }
- selectionChanged { [self notImplemented]; }
- setDefaultContentsIfNil { [self notImplemented]; }
- setPredecessor:newPredecessor { [self notImplemented]; }
- setSuccessor:newSuccessor { [self notImplemented]; }
- text:t testStyle:s { [self notImplemented]; }
- test:t textStyle:s wrap:wrap color:c predecessor:pred successor:succ { [self notImplemented]; }
- updateFromParagraph { [self notImplemented]; }
- updateReferencesUsing:refDict { [self notImplemented]; }

/* containment */

- fillingOnOff { [self notImplemented]; }
- meOrMyDropShadow { [self notImplemented]; }
- occlusionsOnOff { [self notImplemented]; }
- ownerChanged { [self notImplemented]; }
- privateOwner:newOwner { [self notImplemented]; }
- recognizerArena { [self notImplemented]; }
- setContainer:newContainer { [self notImplemented]; }

/* anchors */

- acceptDroppingMorph:aMorph event:evt { [self notImplemented]; }
- addMorphFront:aMorph fromWorldPosition:wp { [self notImplemented]; }
- privateRemoveMorph:aMorph { [self notImplemented]; }

/* copying */

- veryDeepFixupWith:deepCopier { [self notImplemented]; }
- veryDeepInner:deepCopier { [self notImplemented]; }

@end
 
