
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: TextMorph.h,v 1.3 1999/05/26 18:05:28 stes Exp $
 */

#ifndef __TEXTMORPH_H__

#include <Morph.h>

@interface TextMorph : Morph
{
	id textStyle;
	id text;
	BOOL wrapFlag;
	id paragraph;
	id editor;
	id container;
	id predecessor;
	id successor;
}

/* class methods */

+ authoringPrototype;
+ initialize;

/* initialization */

- beAllFont:aFont;
- configureForKids;
- copy;
- initialize;
- releaseCachedState;
- string:aString fontName:aName size:aSize;

/* accessing */

- asText;
- contents;
- contents:stringOrText;
- contents:stringOrText wrappedTo:width;
- contentsAsIs:stringOrText;
- contentsWrapped:stringOrText;
- copyRecordingIn:dict;
- editor;
- newContents:stringOrText;
- userString;

/* alignment */

- centered;
- justified;
- leftFlush;
- rightFlush;

/* drawing */

- drawBoundsOn:aCanvas;
- drawNullTextOn:aCanvas;
- drawOn:aCanvas;

/* editing */

- acceptContents;
- cancelEdits;
- chooseAlignment;
- chooseEmphasis;
- chooseFont;
- chooseStyle;
- clearTypeIn;
- handleEdit:editBlock;
- handleInteraction:interactionBlock fromEvent:evt;
- (BOOL)handlesMouseDown:evt;
- (BOOL)hasFocus;
- (BOOL)hasUnacceptedEdits:(BOOL)aBoolean;
- keyStroke:evt;
- keyboardFocusChange:(BOOL)aBoolean;
- mouseDown:evt;
- mouseMove:evt;
- mouseUp:evt;
- passKeyboardFocusTo:otherMorph;
- xeqLinkText:sourceString withParameter:param;

/* printing */

- fullPrintOn:(IOD)iod;

/* geometry */

- bounds;
- container;
- (BOOL)containsPoint:aPoint;
- defaultLineHeight;
- extent:anExtent;
- goBehind;
- layoutChanged;
- privateMoveBy:delta;
- textBounds;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- addOptionalHandlesTo:aHalo box:box;
- followCurve;
- reverseCurveDirection;
- setCurveBaseline:evt;

/* linked frames */

- addPredecessor:evt;
- addSuccessor:evt;
- firstCharacterIndex;
- firstInChain;
- (BOOL)isLinkedTo:aMorph;
- lastCharacterIndex;
- predecessor;
- recomposeChain;
- startingIndex;
- successor;
- withSuccessorsDo:aBlock;

/* private */

- adjustLineIndicesBy:delta;
- delete;
- fit;
- installEditor;
- installEditorToReplace:priorEditor;
- loadCachedState;
- paragraph;
- paragraphClass;
- predecessorChanged;
- releaseEditor;
- releaseParagraph;
- selectionChanged;
- setDefaultContentsIfNil;
- setPredecessor:newPredecessor;
- setSuccessor:newSuccessor;
- text:t testStyle:s;
- test:t textStyle:s wrap:wrap color:c predecessor:pred successor:succ;
- updateFromParagraph;
- updateReferencesUsing:refDict;

/* containment */

- fillingOnOff;
- meOrMyDropShadow;
- occlusionsOnOff;
- ownerChanged;
- privateOwner:newOwner;
- recognizerArena;
- setContainer:newContainer;

/* anchors */

- acceptDroppingMorph:aMorph event:evt;
- addMorphFront:aMorph fromWorldPosition:wp;
- privateRemoveMorph:aMorph;

/* copying */

- veryDeepFixupWith:deepCopier;
- veryDeepInner:deepCopier;

@end
 
#define __TEXTMORPH_H__
#endif

