
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: StringMorph.m,v 1.2 1999/05/25 20:32:32 stes Exp $
 */

#include "StringMorph.h"

@implementation StringMorph

/* instance creation */

+ authoringPrototype { [self notImplemented]; }
+ contents:aString { [self notImplemented]; }
+ contents:aString font:aFont { [self notImplemented]; }
+ contents:aString font:aFont emphasis:emphasisCode { [self notImplemented]; }

/* testing */

+ test { [self notImplemented]; }
+ test2 { [self notImplemented]; }

/* initialization */

- addOptionalHandlesTo:aHalo box:box { [self notImplemented]; }
- initWithContents:aString font:aFont emphasis:emphasisCode { [self notImplemented]; }
- intialize { [self notImplemented]; }

/* accessing */

- contents { [self notImplemented]; }
- contents:aString { [self notImplemented]; }
- contentsClipped:aString { [self notImplemented]; }
- fitContents { [self notImplemented]; }
- font:aFont { [self notImplemented]; }
- font:aFont emphasis:emphasisCode { [self notImplemented]; }
- fontToUse { [self notImplemented]; }
- setWidth:width { [self notImplemented]; }
- userString { [self notImplemented]; }

/* drawing */

- drawOn:aCanvas { [self notImplemented]; }

/* editing */

- acceptContents { [self notImplemented]; }
- (BOOL)handlesMouseDown:evt { [self notImplemented]; }
- keyStroke:evt { [self notImplemented]; }
- keyboardFocusChange:(BOOL)aBool { [self notImplemented]; }
- mouseDown:evt { [self notImplemented]; }
- (BOOL)wouldAcceptKeyboardFocus { [self notImplemented]; }

/* printing */

- fullPrintOn:(IOD)i { [self notImplemented]; }
- printOn:(IOD)i { [self notImplemented]; }

@end
 
