
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: StringMorph.h,v 1.2 1999/05/25 20:32:32 stes Exp $
 */

#ifndef __STRINGMORPH_H__

#include <Morph.h>

@interface StringMorph : Morph
{
	id font;
	id emphasis;
	id contents;
	BOOL hasFocus;
}

/* instance creation */

+ authoringPrototype;
+ contents:aString;
+ contents:aString font:aFont;
+ contents:aString font:aFont emphasis:emphasisCode;

/* testing */

+ test;
+ test2;

/* initialization */

- addOptionalHandlesTo:aHalo box:box;
- initWithContents:aString font:aFont emphasis:emphasisCode;
- intialize;

/* accessing */

- contents;
- contents:aString;
- contentsClipped:aString;
- fitContents;
- font:aFont;
- font:aFont emphasis:emphasisCode;
- fontToUse;
- setWidth:width;
- userString;

/* drawing */

- drawOn:aCanvas;

/* editing */

- acceptContents;
- (BOOL)handlesMouseDown:evt;
- keyStroke:evt;
- keyboardFocusChange:(BOOL)aBoolean;
- mouseDown:evt;
- (BOOL)wouldAcceptKeyboardFocus;

/* printing */

- fullPrintOn:(IOD)i;
- printOn:(IOD)i;

@end
 
#define __STRINGMORPH_H__
#endif

