
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: SketchMorph.m,v 1.3 1999/05/25 21:17:06 stes Exp $
 */

#include "SketchMorph.h"

@implementation SketchMorph

/* class methods */

+ (BOOL)includeInNewMorphMenu { [self notImplemented]; }

/* initialization */

- initialize { [self notImplemented]; }

/* accessing */

- form { [self notImplemented]; }
- form:aForm { [self notImplemented]; }
- forwardDirection { [self notImplemented]; }
- forwardDirection:degrees { [self notImplemented]; }
- framesToDwell { [self notImplemented]; }
- framesToDwell:anInteger { [self notImplemented]; }
- maxScaleFactor { [self notImplemented]; }
- newScaleFactor:scaleFactor previousScaleFactor:oldScaleFactor { [self notImplemented]; }
- originalForm { [self notImplemented]; }
- referencePosition { [self notImplemented]; }
- referencePosition:aPosition { [self notImplemented]; }
- rotatedForm { [self notImplemented]; }
- rotationCenter { [self notImplemented]; }
- rotationCenter:aPoint { [self notImplemented]; }
- rotationDegrees { [self notImplemented]; }
- rotationDegrees:degrees { [self notImplemented]; }
- rotationDegrees:newRotationDegrees scalePoint:newScalePoint { [self notImplemented]; }
- rotationStyle { [self notImplemented]; }
- rotationStyle:aSymbol { [self notImplemented]; }
- scalePoint { [self notImplemented]; }
- scalePoint:aPoint { [self notImplemented]; }
- setupAngle { [self notImplemented]; }
- setupAngle:degrees { [self notImplemented]; }

/* drawing */

- (BOOL)doesOwnRotation { [self notImplemented]; }
- drawOn:aCanvas { [self notImplemented]; }
- generateRotatedForm { [self notImplemented]; }

/* geometry */

- (BOOL)containsPoint:aPoint { [self notImplemented]; }
- extent:anExtent { [self notImplemented]; }

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph { [self notImplemented]; }
- editDrawing { [self notImplemented]; }
- editDrawingIn:aPasteUpMorph forBackground:forBackground { [self notImplemented]; }
- erasePixelsOfColor:evt { [self notImplemented]; }
- insertIntoMovie:evt { [self notImplemented]; }
- recolorPixelsOfColor:evt { [self notImplemented]; }
- setRotationCenter { [self notImplemented]; }
- setRotationStyle { [self notImplemented]; }

/* change reporting */

- layoutChanged { [self notImplemented]; }

/* other */

- addOptionalHandlesTo:aHalo box:box { [self notImplemented]; }
- (BOOL)colorSettable { [self notImplemented]; }
- newForm:aForm { [self notImplemented]; }
- releaseCachedState { [self notImplemented]; }
- replaceSelfWithMovie { [self notImplemented]; }
- wearCostume:aMorph { [self notImplemented]; }

/* pen support */

- clearExtent:aPoint fillColor:aColor { [self notImplemented]; }
- penOnMyForm { [self notImplemented]; }
- revealPenStrokes { [self notImplemented]; }

@end
 
