
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: SketchMorph.h,v 1.3 1999/05/25 21:17:06 stes Exp $
 */

#ifndef __SKETCHMORPH_H__

#include <Morph.h>

@interface SketchMorph : Morph
{
	id originalForm;
	id rotationCenter;
	id rotationDegrees;
	id rotationStyle;
	id scalePoint;
	id framesToDwell;
	id rotatedForm;
	id offsetWhenRotated;
}

/* class methods */

+ (BOOL)includeInNewMorphMenu;

/* initialization */

- initialize;

/* accessing */

- form;
- form:aForm;
- forwardDirection;
- forwardDirection:degrees;
- framesToDwell;
- framesToDwell:anInteger;
- maxScaleFactor;
- newScaleFactor:scaleFactor previousScaleFactor:oldScaleFactor;
- originalForm;
- referencePosition;
- referencePosition:aPosition;
- rotatedForm;
- rotationCenter;
- rotationCenter:aPoint;
- rotationDegrees;
- rotationDegrees:degrees;
- rotationDegrees:newRotationDegrees scalePoint:newScalePoint;
- rotationStyle;
- rotationStyle:aSymbol;
- scalePoint;
- scalePoint:aPoint;
- setupAngle;
- setupAngle:degrees;

/* drawing */

- (BOOL)doesOwnRotation;
- drawOn:aCanvas;
- generateRotatedForm;

/* geometry */

- (BOOL)containsPoint:aPoint;
- extent:anExtent;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- editDrawing;
- editDrawingIn:aPasteUpMorph forBackground:forBackground;
- erasePixelsOfColor:evt;
- insertIntoMovie:evt;
- recolorPixelsOfColor:evt;
- setRotationCenter;
- setRotationStyle;

/* change reporting */

- layoutChanged;

/* other */

- addOptionalHandlesTo:aHalo box:box;
- (BOOL)colorSettable;
- newForm:aForm;
- releaseCachedState;
- replaceSelfWithMovie;
- wearCostume:aMorph;

/* pen support */

- clearExtent:aPoint fillColor:aColor;
- penOnMyForm;
- revealPenStrokes;

@end
 
#define __SKETCHMORPH_H__
#endif

