
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: PolygonMorph.m,v 1.3 1999/05/24 22:07:04 stes Exp $
 */

#include "PolygonMorph.h"

@implementation PolygonMorph

/* instance creation */

+ shapeFromPen:penBlock color:c borderWidth:bw borderColor:bc { [self notImplemented]; }
+ vertices:verts color:c borderWidth:bw borderColor:bc { [self notImplemented]; }

/* initialization */

- initialize { [self notImplemented]; }
- installModelIn:aWorld { [self notImplemented]; }
- vertices:verts color:c borderWidth:bw borderColor:bc { [self notImplemented]; }

/* access */

- borderColor:bc { [self notImplemented]; }
- borderWidth:(int)bw { [self notImplemented]; }
- (BOOL)isCurve { [self notImplemented]; }
- (BOOL)isOpen { [self notImplemented]; }
- makeClosed { [self notImplemented]; }
- makeOpen { [self notImplemented]; }
- quickFill:(BOOL)aBoolean { [self notImplemented]; }
- vertices { [self notImplemented]; }

/* geometry */

- closestPointTo:aPoint { [self notImplemented]; }
- (BOOL)containsPoint:aPoint { [self notImplemented]; }
- flipHAroundX:centerX { [self notImplemented]; }
- flipVAroundY:centerY { [self notImplemented]; }
- inset:amt { [self notImplemented]; }
- merge:aPolygon { [self notImplemented]; }
- mergeDropThird:mv in:hv from:shared { [self notImplemented]; }

/* drawing */

- areasRemainingToFill:aRectangle { [self notImplemented]; }
- drawBorderOn:aCanvas { [self notImplemented]; }
- drawOn:aCanvas { [self notImplemented]; }

/* editing */

- dragVertex:evt fromHandle:handle vertIndex:(int)ix { [self notImplemented]; }
- dropVertex:evt fromHandle:handle vertIndex:(int)ix { [self notImplemented]; }
- extent:e { [self notImplemented]; }
- newVertex:evt fromHandle:handle afterVert:(int)ix { [self notImplemented]; }

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph { [self notImplemented]; }
- addHandles { [self notImplemented]; }
- makeBackArrow { [self notImplemented]; }
- makeBothArrows { [self notImplemented]; }
- makeForwardArrow { [self notImplemented]; }
- makeNoArrows { [self notImplemented]; }
- removeHandles { [self notImplemented]; }

/* private */

- arrowForms { [self notImplemented]; }
- borderForm { [self notImplemented]; }
- computeArrowFormAt:endPoint from:priorPoint { [self notImplemented]; }
- computeBounds { [self notImplemented]; }
- copyRecordingIn:dict { [self notImplemented]; }
- curveBounds { [self notImplemented]; }
- filledForm { [self notImplemented]; }
- lineSegments { [self notImplemented]; }
- lineSegmentsDo:endpointBlock { [self notImplemented]; }
- loadCachedState { [self notImplemented]; }
- nextToFirstPoint { [self notImplemented]; }
- nexttoLastPoint { [self notImplemented]; }
- privateMoveBy:delta { [self notImplemented]; }
- releaseCachedState { [self notImplemented]; }
- setVertices:newVertices { [self notImplemented]; }
- updateHandles { [self notImplemented]; }

@end

