
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: PolygonMorph.h,v 1.3 1999/05/24 22:07:04 stes Exp $
 */

#ifndef __POLYGONMORPH_H__

#include <BorderedMorph.h>

@interface PolygonMorph : BorderedMorph
{
	id vertices;
	BOOL closed;
	id filledForm;
	BOOL quickFill;
	id arrows;
	id arrowForms;
	id handles;
	id borderForm;
}

/* instance creation */

+ shapeFromPen:penBlock color:c borderWidth:bw borderColor:bc;
+ vertices:verts color:c borderWidth:bw borderColor:bc;

/* initialization */

- initialize;
- installModelIn:aWorld;
- vertices:verts color:c borderWidth:bw borderColor:bc;

/* access */

- borderColor:bc;
- borderWidth:(int)bw;
- (BOOL)isCurve;
- (BOOL)isOpen;
- makeClosed;
- makeOpen;
- quickFill:(BOOL)aBoolean;
- vertices;

/* geometry */

- closestPointTo:aPoint;
- (BOOL)containsPoint:aPoint;
- flipHAroundX:centerX;
- flipVAroundY:centerY;
- inset:amt;
- merge:aPolygon;
- mergeDropThird:mv in:hv from:shared;

/* drawing */

- areasRemainingToFill:aRectangle;
- drawBorderOn:aCanvas;
- drawOn:aCanvas;

/* editing */

- dragVertex:evt fromHandle:handle vertIndex:(int)ix;
- dropVertex:evt fromHandle:handle vertIndex:(int)ix;
- extent:e;
- newVertex:evt fromHandle:handle afterVert:(int)ix;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- addHandles;
- makeBackArrow;
- makeBothArrows;
- makeForwardArrow;
- makeNoArrows;
- removeHandles;

/* private */

- arrowForms;
- borderForm;
- computeArrowFormAt:endPoint from:priorPoint;
- computeBounds;
- copyRecordingIn:dict;
- curveBounds;
- filledForm;
- lineSegments;
- lineSegmentsDo:endpointBlock;
- loadCachedState;
- nextToFirstPoint;
- nexttoLastPoint;
- privateMoveBy:delta;
- releaseCachedState;
- setVertices:newVertices;
- updateHandles;

@end
 
#define __POLYGONMORPH_H__
#endif

