
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: MovieMorph.h,v 1.2 1999/05/24 21:57:21 stes Exp $
 */

#ifndef __MOVIEMORPH_H__

#include <Morph.h>

@interface MovieMorph : Morph
{
}

/* initialization */

- initialize;

/* accessing */

- form;
- maxScaleFactor;
- newScaleFactor:scaleFactor previousScaleFactor:oldScaleFactor;
- rotationDegrees;
- rotationDegrees:newRotationDegrees;
- scalePoint;
- scalePoint:newScalePoint;

/* drawing */

- drawOn:aCanvas;

/* geometry & testing */

- (BOOL)containsPoint:x;

/* stepping */

- step;
- stepTime;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;
- advanceFrame;
- editDrawing;
- extractFrame:evt;
- insertIntoMovie:evt;
- nextFrame;
- playLoop;
- playOnce;
- previousFrame;
- setRotationCenter;
- stopPlaying;

/* private */

- currentFrame;
- insertFrames:newFrames;
- setFrame:newFrameIndex;

@end
 
#define __MOVIEMORPH_H__
#endif

