
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: AlignmentMorph.m,v 1.5 1999/05/29 15:27:05 stes Exp $
 */

#include "AlignmentMorph.h"

@implementation AlignmentMorph

/* instance creation */

+ newColumn { [self notImplemented]; }
+ newRow { [self notImplemented]; }
+ newSpacer:aColor { [self notImplemented]; }
+ newVariableTransparentSpacer { [self notImplemented]; }

/* initialization */

- initialize { [self notImplemented]; }
- addUpDownArrowsFor:aMorph { [self notImplemented]; }

/* classification */

- (BOOL)demandsBoolean { [self notImplemented]; }
- (BOOL)isAlignmentMorph { [self notImplemented]; }

/* accessing */

- centering { [self notImplemented]; }
- centering:aSymbol { [self notImplemented]; }
- chooseOrientation { [self notImplemented]; }
- configureForKids { [self notImplemented]; }
- hResizing { [self notImplemented]; }
- hResizing:aSymbol { [self notImplemented]; }
- inset { [self notImplemented]; }
- inset:anInteger { [self notImplemented]; }
- minCellSize { [self notImplemented]; }
- minCellSize:anInteger { [self notImplemented]; }
- (BOOL)openCloseDragNDrop { [self notImplemented]; }
- (BOOL)openToDragNDrop { [self notImplemented]; }
- openToDragNDrop:(BOOL)aBoolean { [self notImplemented]; }
- orientation { [self notImplemented]; }
- orientation:aSymbol { [self notImplemented]; }
- vResizing { [self notImplemented]; }
- vResizing:aSymbol { [self notImplemented]; }

/* geometry */

- layoutChanged { [self notImplemented]; }

/* dropping / grabbing */

- acceptDroppingMorph:aMorph event:evt { [self notImplemented]; }
- (BOOL)allowSubmorphExtraction { [self notImplemented]; }
- rootForGrabOf:aMorph { [self notImplemented]; }
- (BOOL)wantsDroppedMorph:aMorph event:evt { [self notImplemented]; }

/* layout */

- fullBounds { [self notImplemented]; }
- (int)maxWidth { [self notImplemented]; }
- (int)minHeight { [self notImplemented]; }
- (int)minHeightWhenEmpty { [self notImplemented]; }
- (int)minWidth { [self notImplemented]; }
- (int)minWidthWhenEmtpy { [self notImplemented]; }

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph { [self notImplemented]; }

/* private */

- extraSpacePerMorph { [self notImplemented]; }
- fixLayout { [self notImplemented]; }
- insertionIndexFor:aMorph { [self notImplemented]; }
- layoutInWidth:w height:h { [self notImplemented]; }
- placeAndSize:m at:nextPlace padding:padding { [self notImplemented]; }
- resizeIfNeeded { [self notImplemented]; }
- (BOOL)wantsKeyboardFocusFor:aSubmorph { [self notImplemented]; }

@end
 
