
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: AlignmentMorph.h,v 1.6 1999/05/29 15:27:05 stes Exp $
 */

#ifndef __ALIGNMENTMORPH_H__

#include <RectangleMorph.h>

@interface AlignmentMorph : RectangleMorph
{
	id orientation;
	id centering;
	id hResizing;
	id vResizing;
	id inset;
	id minCellSize;
	BOOL openToDragNDrop;
	BOOL layoutNeeded;
}

/* instance creation */

+ newColumn;
+ newRow;
+ newSpacer:aColor;
+ newVariableTransparentSpacer;

/* initialization */

- initialize;
- addUpDownArrowsFor:aMorph;

/* classification */

- (BOOL)demandsBoolean;
- (BOOL)isAlignmentMorph;

/* accessing */

- centering;
- centering:aSymbol;
- chooseOrientation;
- configureForKids;
- hResizing;
- hResizing:aSymbol;
- inset;
- inset:anInteger;
- minCellSize;
- minCellSize:anInteger;
- (BOOL)openCloseDragNDrop;
- (BOOL)openToDragNDrop;
- openToDragNDrop:(BOOL)aBoolean;
- orientation;
- orientation:aSymbol;
- vResizing;
- vResizing:aSymbol;

/* geometry */

- layoutChanged;

/* dropping / grabbing */

- acceptDroppingMorph:aMorph event:evt;
- (BOOL)allowSubmorphExtraction;
- rootForGrabOf:aMorph;
- (BOOL)wantsDroppedMorph:aMorph event:evt;

/* layout */

- fullBounds;
- (int)maxWidth;
- (int)minHeight;
- (int)minHeightWhenEmpty;
- (int)minWidth;
- (int)minWidthWhenEmtpy;

/* menu */

- addCustomMenuItems:aCustomMenu hand:aHandMorph;

/* private */

- extraSpacePerMorph;
- fixLayout;
- insertionIndexFor:aMorph;
- layoutInWidth:w height:h;
- placeAndSize:m at:nextPlace padding:padding;
- resizeIfNeeded;
- (BOOL)wantsKeyboardFocusFor:aSubmorph;

@end
 
#define __ALIGNMENTMORPH_H__
#endif

