
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: BouncingAtomsMorph.h,v 1.1 1999/05/29 10:45:20 stes Exp $
 */

#ifndef __BOUNCINGATOMSMORPH_H__

#include <Morph.h>

@interface BouncingAtomsMorph : Morph
{
  BOOL damageReported;
  BOOL transmitInfection;
  id infectionHistory;
  int temperature;
  id recentTemperatures;
}

- initialize;
- addCustomMenuItems:aMenu hand:aHandMorph;
- setAtomCount;
- startInfection;
- step;
- stepTime;
- addAtoms:(int)n;
- addMorphFront:aMorph;
- areasRemainingToFill:aRect;
- collisionPairs;
- drawOn:aCanvas;
- invalidRect:damageRect;
- showInfectionHistory:evt;
- transmitInfection;
- updateTemperature:x;

@end
 
#define __BOUNCINGATOMSMORPH_H__
#endif

