
/*
 * Objective-C version of Squeak Morphic. Copyright (c) 1999 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: AtomMorph.m,v 1.2 1999/05/29 13:47:45 stes Exp $
 */

#include "AtomMorph.h"
#include <Color.h>

#include <objpak.h>

#include <stdlib.h> // random()
#include <assert.h> 

@implementation AtomMorph

//
// Not to be instantiated from the Menu
//

+ (BOOL)includeInNewMorphMenu
{
  return NO;
}

//
// Make a new atom with a random position and velocity
//

- initialize
{
  id r;
  [super initialize];
  [self extent:[Point x:8 y:7]];
  [self color:[Color blue]];
  [self borderWidth:0];
  r = [Rectangle origin:0:0 corner:300:300];
  [self randomPositionIn:r maxVelocity:10];
  return self;
}

//
// Move this atom one step along its velocity vector and make it bounce
// if it goes outside the given rectangle.  Return YES if it is bounced.
//

- (BOOL) bounceIn:aRect
{
  int vx,vy,px,py;
  BOOL bounced = NO;
  id p = [self position];

  vx = [velocity x];
  vy = [velocity y];

  px = [p x] + vx;
  py = [p y] + vy;

  if (px > [aRect right]) {
     bounced = YES;
     px = [aRect right] - (px - [aRect right]);
     vx = -vx;
  }

  if (py > [aRect bottom]) {
     bounced = YES;
     py = [aRect bottom] - (py - [aRect bottom]);
     vy = -vy;
  }

  if (px < [aRect left]) {
     bounced = YES;
     px = [aRect left] - (px - [aRect left]);
     vx = -vx;
  }

  if (py < [aRect top]) {
     bounced = YES;
     py = [aRect top] - (py - [aRect top]);
     vy = -vy;
  }

  [self position:[Point x:px y:py]];

  if (bounced) [self velocity:[Point x:vx y:vy]];

  return bounced;
}

//
// Compile with -DDRAWASRECT when testing the speed of other aspects of
// Morphic.  For large numbers of atoms, it is useful to make atom drawing
// faster.
//

- drawOn:aCanvas
{
#ifdef DRAWASRECT
  [aCanvas fillRectangle:[self bounds] color:color];
#else
  [super drawOn:aCanvas];
#endif
  return self;
}

- (BOOL)infected
{
  return color == [Color red];
}

- infected:(BOOL)aBoolean
{
  color = (aBoolean)?[Color red]:[Color blue];
  return self;
}

//
// Give this atom a random position and velocity
//

#define atrandom(x) (random() % (x))

- randomPositionIn:aRect maxVelocity:(int)maxv
{
  id p,v;
  id o = [aRect origin];
  int ex = [aRect width] - [[self bounds] width];
  int ey = [aRect height] - [[self bounds] height];

  p = [Point x:[o x]+atrandom(ex) y:[o y]+atrandom(ey)];
  [self position:p];

  v = [Point x:maxv-atrandom(2*maxv) y:maxv-atrandom(2*maxv)];
  [self velocity:v];

  return self;
}

- velocity
{
  return velocity;
}

- velocity:v
{
  velocity = v;
  return self;
}

@end

