
/*
 * Inetpak (c) 1998 by David Stes.  All Rights Reserved.
 * $Id$
 */

/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __WEBSERVER_H__
#define __WEBSERVER_H__

#include "objc.h"

#define RLINEMAX 512

#ifndef SERVER_USE_SELECT
#define SERVER_USE_SELECT 0
#endif

@interface Webserver : Object
{
  int listenfd;
  int connfd;
  int portnum;
  BOOL daemon;
  BOOL blocking;
  BOOL child;
  id readfds;
  id writefds;
  id readblks;
  id writeblks;
  int ci;
  int cn;
  char lbuf[RLINEMAX];
  char cbuf[RLINEMAX];
  SEL method;
  id request;
  id protocolname;
  id host;
  id acceptencoding;
  id acceptlanguage;
  id useragent;
  id connection;
}

+ new;
+ argc:(int)n argv:(char**)v;

- setportnum:(int)num;
- setdaemon:(BOOL)flag;
- setblocking:(BOOL)flag;
- argc:(int)n argv:(char**)v;

- bind;
- halt:msg;
- detach;
- errorresponse:(STR)msg;
- responseheader;
- (int) readline;
- parserequest;
- parseheader;
- (BOOL) iscrnl;
- parse;
- delrequest;
- reply;
- get;
- head;
- post;
- run;
#if SERVER_USE_SELECT
- if:(int)fd readable:aBlock;
- if:(int)fd writable:aBlock;
- (int) maxfd;
- calcreadset:(fd_set *)p;
- doreadblks:(fd_set *)p;
- calcwriteset:(fd_set *)p;
- dowriteblks:(fd_set *)p;
- select;
#endif				/* SERVER_USE_SELECT */

- poll;
- (int) listenfd;

- accepted;
- contents;
@end

#endif				/* __WEBSERVER_H__ */

