
#include <objpak.h>
#include "webserver.h"
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>

static id cls;

@implementation Peep : Webserver
- contents
  {
    printf("<HTML>\n");
    printf("<TITLE>Peep Server</TITLE>\n");
    printf("<H1>Class Peep</H1>\n");
    printf("<P>This is a utility to monitor, system-wide, the use of Objective-C classes\n");
    printf("<P>There have been %d class(es) used.</P>\n",[cls size]);
    printf("<P>Set the environment variable OBJCRTMSG to /tmp/peep to start monitoring classes in use.</P>\n");
    printf("<P>Names of classes:</P>\n");
    printf("<OL>\n");
    [cls do:{ :each | printf("<LI>%s</LI>\n",[each str]); }];
    printf("</OL>\n");
    printf("</HTML>\n");
    return self;
  }
@end

void apeep(id app,FILE *f);

void mkpeep(void)
{
  unlink("/tmp/peep");
  if (mkfifo("/tmp/peep",S_IRUSR | S_IWUSR) < 0) {
    fprintf(stderr,"can't create /tmp/peep fifo.\n");exit(1);
  }
}

FILE *peepopen(void)
{
  int fd;
  FILE *f;
  if ((fd = open("/tmp/peep",O_RDONLY | O_NDELAY)) < 0) {
    fprintf(stderr,"can't open /tmp/peep for reading.\n");exit(1);
  }
  if ((f = fdopen(fd,"r")) == NULL) {
    fprintf(stderr,"can't open /tmp/peep for reading.\n");exit(1);
  }
  return f;
}

void apeep(id app,FILE *f)
{
    char buf[BUFSIZ];

    if (fgets(buf,BUFSIZ,f)) {
      [cls add:[String str:strtok(buf," \t")]];
    } else {
      /* unregister, close FIFO and reopen and register again */
      [app if:fileno(f) readable:nil];
      fclose(f);
      f = peepopen();
      [app if:fileno(f) readable:{ apeep(app,f); }];
    }
}

void main(int n,char **v)
{
  id app;
  FILE *f;

  cls = [Set new];
  app  = [Peep argc:n argv:v];

  mkpeep();
  f = peepopen();
  [app if:fileno(f) readable:{ apeep(app,f); } ];
  [app run];
  exit(0);
}

