
#include "webserver.h"
#include <signal.h>

#include <time.h>
#include <sys/utsname.h>

static int n;
static char* version;

@implementation Demoserver : Webserver
+ initialize
  {
    version = [Object objcrtRevision];
    return self;
  }
- accepted
  {
    if (strcmp([request str],"/clear")==0) {
      n = 0;
      return self;
    }
    if (strcmp([request str],"/subtract")==0) {
      n--;
      return self;
    }
    if (strcmp([request str],"/fake")==0) {
      n += 100;
      return self;
    }
    n++;
    return self;
  }
- contents
  {
    time_t x;
    struct utsname un;

    time(&x);
    uname(&un);

    printf("<HTML>\n");
    printf("<TITLE>Demo Server</TITLE>\n");
    printf("<H1>Demo server</H1>\n");
    printf("<P>Server compiled with POC version %s</P>\n",version);
    printf("<P>Machine is running %s, %s</P>\n",un.sysname,un.release);
    printf("<P>Local time is %s</P>\n",ctime(&x));
    printf("<P>Page has been <A HREF=\"/load\">loaded</A> %i %s.</P>\n",n,(n==1)?"time":"times");
    printf("<P>You can <A HREF=\"/clear\">reset</A> the counter ! ");
    printf("Or <A HREF=\"/fake\">fake</A> 100 requests at a time ... ");
    printf("Go below <A HREF=\"/subtract\">zero</A>.</P>\n");
    printf("</HTML>\n");

    return self;
  }
@end

void main(int n,char **v)
{
  id app = [Demoserver argc:n argv:v];
  [app run];
  exit(0);
}

