
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ex7.h"

int main(int argc,char **argv)
{
   int sockfd,n;
   struct sockaddr_in servaddr;
   id x,y,epubkey,k,q,u,v,msg,servkey;

   if (argc!=2) { printf("Usage: ex2client ip-addr (x.x.x.x)\n");exit(0); }

   setup();

   if ((sockfd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
     perror("socket");exit(0);
   } 

   memset(&servaddr,0,sizeof(struct sockaddr_in));
   servaddr.sin_family = AF_INET; 
   servaddr.sin_port = htons(PORT); 
   if (inet_aton(argv[1],&servaddr.sin_addr) <= 0) {
      perror("aton");printf("Usage: ex1client ip-addr (x.x.x.x)\n");exit(0);
   }
  
   if (connect(sockfd,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in))<0) {
     perror("socket");exit(0);
   }

   printf("Public key of server : \n");
   x = [field embed:[BigInt str:serv_pubkeyx]];
   y = [field embed:[BigInt str:serv_pubkeyy]];
   servkey = [[PointOfCurve X:x Y:y] curve:curve];
   [servkey printLine];

   printf("Get message from server  ... : \n");
   msg = [servkey receiveFrom:sockfd];
   [msg printLine];

   printf("Get Nyberg Rueppel message signature from server  ... : \n");
   k = receivebigint(sockfd);
   [k printLine];
   q = [servkey receiveFrom:sockfd];

   printf("Verifying message signature (this may take a while...) : \n");
   printdots++;
   u = [[msg multiply:k] subtract:basepoint];
   v = [[q multiply:k] subtract:[servkey multiply:[[q X] asBigInt]]];
   printdots=0;
   printf("\n");
 
   if ([u isEqual:v]) {
     printf("Message signature matches public key of server\n");
   } else {
     printf("Message signature does NOT match public key of server\n");
   }
}

