
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ex6.h"

int main(int argc,char **argv)
{
   int sockfd,n;
   struct sockaddr_in servaddr;
   id k,x,y,q,privkey,pubkey,ppubkey,eprivkey,epubkey,s,t,u;

   setup();

   if (argc!=2) { printf("Usage: ex2client ip-addr (x.x.x.x)\n");exit(0); }

   q = [field cardinality];
   privkey = [BigInt str:cli_privkey];
   printf("Private key : \n");[privkey printLine];

   printf("Public key : \n");
   x = [field embed:[BigInt str:cli_pubkeyx]];
   y = [field embed:[BigInt str:cli_pubkeyy]];
   pubkey = [[PointOfCurve X:x Y:y] curve:curve];
   [pubkey printLine];

   printf("Public key of server : \n");
   x = [field embed:[BigInt str:serv_pubkeyx]];
   y = [field embed:[BigInt str:serv_pubkeyy]];
   ppubkey = [[PointOfCurve X:x Y:y] curve:curve];
   [ppubkey printLine];

   eprivkey = [bigintrandom([order numDigits]) modulo:order];
   printf("Ephemeral Private key : \n");[eprivkey printLine];

   printf("Ephemeral Public key (this may take a while to compute given the private key, and the reverse should be even harder to compute): \n");
   printdots++;epubkey = [basepoint multiply:eprivkey];printdots=0;printf("\n");
   [epubkey printLine];

   if ((sockfd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
     perror("socket");exit(0);
   } 

   memset(&servaddr,0,sizeof(struct sockaddr_in));
   servaddr.sin_family = AF_INET; 
   servaddr.sin_port = htons(PORT); 
   if (inet_aton(argv[1],&servaddr.sin_addr) <= 0) {
      perror("aton");printf("Usage: ex1client ip-addr (x.x.x.x)\n");exit(0);
   }
  
   if (connect(sockfd,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in))<0) {
     perror("socket");exit(0);
   }

    [epubkey sendOn:sockfd];
    k = [pubkey receiveFrom:sockfd];
    printf("Ephemeral public key of peer : \n");
    [k printLine];

    s = [[[epubkey X] multiply:[pubkey X]] asBigInt];
    t = [privkey add:[s multiply:eprivkey]];
    t = [t modulo:order];

    printf("Shared Menezes-Qu-Vanstone secret : \n");
    printdots++;
    s = [[[k X] multiply:[ppubkey X]] asBigInt];
    u = [ppubkey add:[k multiply:[s modulo:order]]];
    u = [u multiply:t];
    printdots = 0; printf("\n");

    [u printLine];
}

