
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ex5.h"

int main(int argc,char **argv)
{
  id a,b,msg;
  int listenfd,connfd;
  struct sockaddr_in servaddr;

  setup();

  if ((listenfd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
    perror("socket");exit(0);
  }

  memset(&servaddr,0,sizeof(struct sockaddr_in));
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servaddr.sin_port = htons(PORT);

  if (bind(listenfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
    perror("bind");exit(0);
  }

  if (listen(listenfd,LISTENQ) < 0) {
    perror("listen");exit(0);
  }

  printf("\nReady to accept connections ...\n");
  
  while (1) {
    connfd = accept(listenfd,(struct sockaddr *)NULL,NULL); 
    if (connfd < 0) { perror("accept");continue; }

    printf("Got message from peer : \n");
    msg = [basepoint receiveFrom:connfd];

    do {
     a = [bigintrandom([order numDigits]/2) modulo:order];
    } while ([[a gcd:order] notOne]);
    b = [bezout(a,order) modulo:order];

    printf("Sending back message multiplied by : ");[a printLine];
    printdots++;msg = [msg multiply:a];printdots=0;printf("\n");
    [msg sendOn:connfd];

    msg = [msg receiveFrom:connfd];
    printf("Decoding message multiplying by : ");[b printLine];
    printdots++;msg = [msg multiply:b];printdots=0;printf("\n");

    [msg printLine];
  }
}

