
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ex5.h"

int main(int argc,char **argv)
{
   id a,b,msg,q;
   int sockfd,n;
   struct sockaddr_in servaddr;

   if (argc!=2) { printf("Usage: ex2client ip-addr (x.x.x.x)\n");exit(0); }

   setup();

   printf("Embedding message on curve ... (computing square-root) : \n");
   q = [field cardinality];
   msg = [bigintrandom([q numDigits]) modulo:q];
   msg = [curve embed:msg];
   [msg printLine];

   do {
     a = [bigintrandom([order numDigits]/2) modulo:order];
    } while ([[a gcd:order] notOne]);
   b = [bezout(a,order) modulo:order];

   printf("Multiplying message by : ");[a printLine];
   printdots++;msg = [msg multiply:a];printdots=0;printf("\n");

   if ((sockfd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
     perror("socket");exit(0);
   } 

   memset(&servaddr,0,sizeof(struct sockaddr_in));
   servaddr.sin_family = AF_INET; 
   servaddr.sin_port = htons(PORT); 
   if (inet_aton(argv[1],&servaddr.sin_addr) <= 0) {
      perror("aton");printf("Usage: ex1client ip-addr (x.x.x.x)\n");exit(0);
   }
  
   if (connect(sockfd,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in))<0) {
     perror("socket");exit(0);
   }

   [msg sendOn:sockfd];
   msg = [msg receiveFrom:sockfd];

   printf("Sending back message multiplied by : ");[b printLine];
   printdots++;msg = [msg multiply:b];printdots=0;printf("\n");

   [msg sendOn:sockfd];
}

