
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ex4.h"

int main(int argc,char **argv)
{
  int listenfd,connfd;
  id privkey,pubkey,eprivkey,eprivkeyinv,epubkey,q,x,y,msg;
  struct sockaddr_in servaddr;

  setup();

  q = [field cardinality];
  privkey = [BigInt str:serv_privkey];
  printf("Private key : \n");[privkey printLine];

  printf("Public key : \n");
  x = [field embed:[BigInt str:serv_pubkeyx]];
  y = [field embed:[BigInt str:serv_pubkeyy]];
  pubkey = [[PointOfCurve X:x Y:y] curve:curve];
  [pubkey printLine];

  do  {
  eprivkey = [bigintrandom([order numDigits]) modulo:order];
  } while ([[eprivkey gcd:order] notOne]);
  printf("Ephemeral Private key (coprime to order) : \n");[eprivkey printLine];
  eprivkeyinv = bezout(eprivkey,order);

  printf("Ephemeral Public key (this may take a while to compute given the private key, and the reverse should be even harder to compute): \n");
  printdots++;epubkey = [basepoint multiply:eprivkey];printdots=0;printf("\n");
  [epubkey printLine];
  
  if ((listenfd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
    perror("socket");exit(0);
  }

  memset(&servaddr,0,sizeof(struct sockaddr_in));
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servaddr.sin_port = htons(PORT);

  if (bind(listenfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
    perror("bind");exit(0);
  }

  if (listen(listenfd,LISTENQ) < 0) {
    perror("listen");exit(0);
  }

  printf("\nReady to accept connections ...\n");
  
  while (1) {
    id k;
    connfd = accept(listenfd,(struct sockaddr *)NULL,NULL); 
    if (connfd < 0) { perror("accept");continue; }

    printf("Sending ephemeral public key to client.\n");
    [epubkey sendOn:connfd];

    do {
    msg = [bigintrandom([order numDigits]) modulo:order];
    k = [msg add:[privkey multiply:[[epubkey X] asBigInt]]];
    k = [k multiply:eprivkeyinv modulo:order];
    } while ([[k gcd:order] notOne]);

    printf("Sending message to client : \n");
    [msg printLine];
    sendbigint(connfd,msg);

    printf("Sending D.S.A. message signature to client : \n");
    [k printLine];
    sendbigint(connfd,k);
  }
}

