
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "StdCurve1.h"
#include "GaloisField.h"
#include "PointOfCurve.h"
#include "BigRandom.h"
#include "Bezout.h"

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define FP 47
#define FN 61
#define PORT 5003
#define MAXLINE 256
#define LISTENQ 1

int cup[] = {12,10};
char* bpx = "768951631124208320858971574172869937150339733848527849315884209419595511805445903491033467191925097674";
char* bpy = "84664051550885427999471634530453958445409362925113914048684122067936269254250295314554355793746271382";
char* orderc = "995335133367449946250963967342411763029420336473507952618083727735441669408241369524977176110912034440"; 
char *serv_privkey = "510938088245252277651509998073683098241028369253539395584081687869253871449146662231627473812287634299";
char *serv_pubkeyx = "742711416991727888130476435193221810155900803087429169186040346993805529582443536904347396584408827742";
char *serv_pubkeyy = "404874852157708816672474747037715291079047020863375950714552510232296470076315319644459274873675242707";

id field,curve,basepoint,order;

void setup(void)
{
  id x,y;

  srandom(time(NULL)); // for private key

  field = [GaloisField characteristic:FP degree:FN];
  printf("Galois Field : F_{%d^%d}\n",FP,FN);
  [field calcfrobtab];
  printf("Cardinality of field : ");
  [[field cardinality] printLine];
  curve = [StdCurve1 a:[field intValue:cup[0]] e:[field intValue:cup[1]]];
  printf("Curve : ");
  [curve printLine];
  order = [BigInt str:orderc];
  printf("Order of Curve : ");
  [order printLine];
  x = [field embed:[BigInt str:bpx]];
  y = [field embed:[BigInt str:bpy]];
  basepoint = [[PointOfCurve X:x Y:y] curve:curve];
  printf("Base point : ");
  [basepoint printLine];
}

