
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ex2.h"

int main(int argc,char **argv)
{
  int listenfd,connfd;
  id privkey,pubkey,q,x,y,msg;
  struct sockaddr_in servaddr;

  setup();

  q = [field cardinality];
  privkey = [BigInt str:serv_privkey];
  printf("Private key : \n");[privkey printLine];

  printf("Public key : \n");
  x = [field embed:[BigInt str:serv_pubkeyx]];
  y = [field embed:[BigInt str:serv_pubkeyy]];
  pubkey = [[PointOfCurve X:x Y:y] curve:curve];
  [pubkey printLine];
  
  if ((listenfd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
    perror("socket");exit(0);
  }

  memset(&servaddr,0,sizeof(struct sockaddr_in));
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servaddr.sin_port = htons(PORT);

  if (bind(listenfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
    perror("bind");exit(0);
  }

  if (listen(listenfd,LISTENQ) < 0) {
    perror("listen");exit(0);
  }

  printf("\nReady to accept connections ...\n");
  
  while (1) {
    id k;
    connfd = accept(listenfd,(struct sockaddr *)NULL,NULL); 
    if (connfd < 0) { perror("accept");continue; }

    k = [pubkey receiveFrom:connfd];
    msg = [pubkey receiveFrom:connfd];

    printf("Got message from peer : \n");
    printf("Decrypting message with private key : \n");
    printdots++;msg = [msg subtract:[k multiply:privkey]];printdots=0;printf("\n");
    [msg printLine];
  }
}

