
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ex2.h"

int main(int argc,char **argv)
{
   id k;
   int sockfd,n;
   struct sockaddr_in servaddr;
   id x,y,privkey,pubkey,q,msg,servkey;

   if (argc!=2) { printf("Usage: ex2client ip-addr (x.x.x.x)\n");exit(0); }

   setup();

   if ((sockfd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
     perror("socket");exit(0);
   } 

   memset(&servaddr,0,sizeof(struct sockaddr_in));
   servaddr.sin_family = AF_INET; 
   servaddr.sin_port = htons(PORT); 
   if (inet_aton(argv[1],&servaddr.sin_addr) <= 0) {
      perror("aton");printf("Usage: ex1client ip-addr (x.x.x.x)\n");exit(0);
   }
  
   if (connect(sockfd,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in))<0) {
     perror("socket");exit(0);
   }

   printf("Public key of server : \n");
   x = [field embed:[BigInt str:serv_pubkeyx]];
   y = [field embed:[BigInt str:serv_pubkeyy]];
   servkey = [[PointOfCurve X:x Y:y] curve:curve];
   [servkey printLine];

   q = [field cardinality];
   privkey = [bigintrandom([q numDigits]/4) modulo:q];
   printf("Ephemeral Private key : \n");[privkey printLine];

   printf("Ephemeral Public key (this may take a while to compute given the private key, and the reverse should be even harder to compute): \n");
   printdots++;pubkey = [basepoint multiply:privkey];printdots=0;printf("\n");
   [pubkey printLine];

   printf("Embedding message on curve ... (computing square-root) : \n");
   msg = [bigintrandom([q numDigits]) modulo:q];
   msg = [curve embed:msg];
   [msg printLine];

   printf("Encrypting message and sending to server ... : \n");
   printdots++;msg = [msg add:[servkey multiply:privkey]];printdots=0;printf("\n");

   [pubkey sendOn:sockfd];
   [msg sendOn:sockfd];
}

