
#include "StdCurve1.h"
#include "PointOfCurve.h"
#include "BigIntModp.h"
#include "BigRandom.h"

#include <ocstring.h>

main()
{
  id a,e,x,y,z;
  id k,l,r,b,s,t,pr,pb;
  id curve;
#if 1
  id p = [BigInt str:"1000000000000843"];
  id c = [BigIntModp value:[BigInt new] modulus:p];
#else
  id c = [IntegerModp int:0 modulus:7];
#endif

#if 1
  x = [c intValue:80];
  a = [c intValue:-121];
  e = [c intValue:-281];
  a = [a divide:x];
  e = [e divide:x];
#else
  x = [BigInt int:80];
  a = [BigInt int:-121];
  e = [BigInt int:-281];
  a = [Fraction numerator:a denominator:x];
  e = [Fraction numerator:e denominator:x];
#endif

  curve = [StdCurve1 a:a e:e];
  [curve printLine];
 
  a = [a intValue:2];
  e = [e intValue:18];
  x = [e intValue:11];
  e = [e divide:x];
  x = [e one];

  x = [[PointOfCurve X:a Y:e Z:x] curve:curve];
  [x printLine];
  
  printf("Private key of A\n");
  k = bigintrandom([p numDigits]);
  [k printLine];

  printf("Private key of B\n");
  l = bigintrandom([p numDigits]);
  [l printLine];

  printf("Public key of A\n");
  s = [x multiply:k]; 
  [s printLine];

  printf("Public key of B\n");
  t = [x multiply:l]; 
  [t printLine];

  printf("Private encryption key A -> B\n");
  r = bigintrandom([p numDigits]);
  [r printLine];

  printf("Public encryption key A -> B\n");
  pr = [x multiply:r];
  [pr printLine];

  printf("Message from A to B\n");
  [b printLine];
  b = [curve embed:b];
  [b printLine];

  pb = [b subtract:[t multiply:r]];

  printf("B decoding of message\n");
  pr = [pr multiply:l];
  [pr printLine];
  pb = [pb add:pr];
  [pb printLine];
  [[pb asBigInt] printLine]; 
}

