
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "WeierstrassCurve.h"
#include "PointOfCurve.h"
#include "BigIntModp.h"

#include <assert.h>

#define a1 b
#define a3 c
#define a2 e
#define a4 f
#define a6 g

@implementation WeierstrassCurve

- shortform:A4:A6
{
  id z = [A4 zero];shortform++;return [self longform:z:z:z:A4:A6];
}

- longform:A1:A2:A3:A4:A6
{
  a = [A1 one];
  b = A1;
  c = A3;
  d = [A1 one];
  e = A2;
  f = A4;
  g = A6;
  return self;
}

+ shortform:A4:A6
{
  return [[super new] shortform:A4:A6];
}

+ longform:A1:A2:A3:A4:A6
{
  return [[super new] longform:A1:A2:A3:A4:A6];
}

- b2
{
  return (b2)?b2:(b2 = [[a1 square] add:[a2 quadruple]]);
}

- b4
{
  return (b4)?b4:(b4 = [[a1 multiply:a3] add:[a4 double]]);
}

- b6
{
  return (b6)?b6:(b6 = [[a3 square] add:[a6 quadruple]]);
}

- b8
{
  if (b8) {
    return b8;
  } else {
    b8 = [[a1 square] multiply:a6];
    b8 = [b8 add:[[a2 multiply:a6] quadruple]];
    b8 = [b8 subtract:[[a1 multiply:a3] multiply:a4]];
    b8 = [b8 add:[[a3 square] multiply:a2]];
    b8 = [b8 subtract:[a4 square]];
    return b8;
  }
}

- c4
{
  if (c4) {
    return c4;
  } else {
    [self b2];[self b4];
    return c4 = [[b2 square] subtract:[b4 multiplyIntValue:24]]; 
  }
}

- c6
{
  if (c6) {
    return c6;
  } else {
    [self b2];[self b4];[self b6];
    return c6 = [[[[b2 multiply:b4] multiplyIntValue:36] subtract:[b2 power:3]] subtract:[b6 multiplyIntValue:216]]; 
  }
}

- j_invariant
{
  if (j) return j;
  j = [[[self c4] power:3] divide:[self discriminant]];
  return j;
}

- discriminant
{
  if (disc) return disc;
  [self b2];[self b4];[self b6];[self b8]; 
  disc = [[[b2 multiply:b4] multiply:b6] multiplyIntValue:9];
  disc = [disc subtract:[[b6 square] multiplyIntValue:27]];
  disc = [disc subtract:[[b4 power:3] multiplyIntValue:8]];
  disc = [disc subtract:[[b2 square] multiply:b8]];
  return disc;
}

- xembed:aString
{
  assert(a!=nil); return [a embed:aString];
}

- pointatx:x
{
  id fx,z = [x one];
  if (!shortform) [self notImplemented];
  fx = [[self evalrhs:x:z] divide:a];
  if ([fx isSquare]) {
   id y = [fx squareRoot];
   return [[PointOfCurve X:x Y:y Z:[x one]] curve:self];
  } else {
   return nil;
  }
}

- negatepoint:p
{
  id x,y;
  x = [p X];
  y = [[[[p Y] negate] subtract:[a1 multiply:x]] subtract:a3];
  return [p X:x Y:y];
}

- doublepoint:p
{
  id t;
  id u,v;
  id px,qx,py,z;
  id lambda,mu;
  z = [p Z];
  px = [p X];
  qx = px;
  py = [p Y];
  if ([z isZero] || [py isZero]) {
    return [p zero];
  } else {
    id de = [[[py double] add:[a1 multiply:px]] add:a3];
    lambda = [[[[[[px square] multiplyIntValue:3] add:[[a2 multiply:px] double]] add:a4] subtract:[a1 multiply:py]] divide:de];
    mu = [[[[[a6 double] add:[a4 multiply:px]] subtract:[a3 multiply:py]] subtract:[px power:3]] divide:de];
    u = [[[[[lambda square] add:[a1 multiply:lambda]] subtract:a2] subtract:px] subtract:qx];
    v = [[[a3 negate] subtract:mu] subtract:[[lambda add:a1] multiply:u]];
    return [p X:u Y:v Z:[u one]];
  }
}

- addpoint:p to:q
{
  id u,v;
  id lambda,mu;
  id px,py,pz;
  id qx,qy,qz;

  if ([p isZero]) return q;
  if ([q isZero]) return p;
  if ([p isEqual:q]) return [self doublepoint:p];

  pz = [p Z]; px = [p X]; py = [p Y];
  qz = [q Z]; qx = [q X]; qy = [q Y];

  if ([px isEqual:qx]) {
    if ([p isOpposite:q]) {
      return [p zero];
    } else {
      id de = [[[py double] add:[a1 multiply:px]] add:a3];
      lambda = [[[[[[px square] multiplyIntValue:3] add:[[a2 multiply:px] double]] add:a4] subtract:[a1 multiply:py]] divide:de];
      mu = [[[[[a6 double] add:[a4 multiply:px]] subtract:[a3 multiply:py]] subtract:[px power:3]] divide:de];
    }
  } else {
    lambda = [[qy subtract:py] divide:[qx subtract:px]];
    mu = [[[py multiply:qx] subtract:[qy multiply:px]] divide:[qx subtract:px]];
  }
  u = [[[[[lambda square] add:[a1 multiply:lambda]] subtract:a2] subtract:px] subtract:qx];
  v = [[[a3 negate] subtract:mu] subtract:[[lambda add:a1] multiply:u]];
  return [p X:u Y:v Z:[u one]];
}

@end

