
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef WEIERSTRASSCURVE_H

#include "EllipticCurve.h"

@interface WeierstrassCurve : EllipticCurve
{
  /* cfr. Nigel Smart, Elliptic Curves in Cryptography */
  /* y^2 z + a1 x y z + a3 y z^2 == x^3 + a2 x^2 z + a4 x z^2 + a6 z^3 */
  id b2,b4,b6,b8;
  id c2,c4,c6;
  id j,disc;
  BOOL shortform;
}

+ shortform:A4:A6;
+ longform:A1:A2:A3:A4:A6;

- j_invariant;
- discriminant;

- negatepoint:p;
- subtractpoint:q from:p;
- multiplypoint:q by:n;

@end

#define WEIERSTRASSCURVE_H
#endif

