
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "StdCurve2.h"
#include "PointOfCurve.h"

  /* cfr. Michael Rosing, Elliptic Curve Cryptography */
  /* y^2 + xy == x^3 + e x^2 + g */

@implementation StdCurve2

- check
{
  if (c!=nil || f!=nil || [g isZero]) [self notImplemented];
  return self;
}

- e:E g:G
{
  a = [E one];
  b = [E one];
  d = [E one];
  e = E;
  g = G;
  return [self check]; 
}

+ e:E g:G
{
  return [[super new] e:E g:G];
}

- negatepoint:p
{
  return [self notImplemented];
}

- addpoint:p to:q
{
  return [self notImplemented];
}

- subtractpoint:q from:p
{
  return [self notImplemented];
}

- multiplypoint:q by:n
{
  return [self notImplemented];
}

@end

