
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef STDCURVE2_H

#include "WeierstrassCurve.h"

@interface StdCurve2 : WeierstrassCurve
{
  /* cfr. Michael Rosing, Elliptic Curve Cryptography */
  /* y^2 + xy == x^3 + e x^2 + g */
}

+ e:E g:G;

- negatepoint:p;
- addpoint:p to:q;
- subtractpoint:q from:p;

@end

#define STDCURVE2_H
#endif

