
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "StdCurve1.h"
#include "PointOfCurve.h"
#include "BigIntModp.h"

#include <assert.h>

/* cfr. Hans Riesel, Prime Numbers and Computer Methods for Factorization */
/* a y^2 == x^3 + e x^2 + x */

@implementation StdCurve1

- check
{
  if (b!=nil || c!=nil || g!=nil) [self notImplemented];
  return self;
} 

- a:A e:E
{
  a = A;
  d = [A one];
  e = E;
  f = [A one]; 
  return [self check];
}

+ a:A e:E
{
  return [[super new] a:A e:E];
}

- xembed:aString
{
  assert(a!=nil); return [a embed:aString];
}

- (int)countatx:x
{
  id fx,z = [x one];
  fx = [[self evalrhs:x:z] divide:a];
  if ([fx isZero]) return 1;
  if ([fx isSquare]) return 2;
  return 0;
}

- pointatx:x
{
  id fx,z = [x one];
  fx = [[self evalrhs:x:z] divide:a];
  if ([fx isSquare]) {
   id y = [fx squareRoot];
   return [[PointOfCurve X:x Y:y Z:[x one]] curve:self];
  } else {
   return nil;
  }
}

- negatepoint:p
{
  return [p X:[p X] Y:[[p Y] negate]];
}

- doublepoint:p
{
  id t;
  id u,v;
  id x,y,z;
  id lambda;
  z = [p Z];
  x = [p X];
  y = [p Y];
  if ([z isZero] || [y isZero]) {
    return [p zero];
  } else {
    id x2 = [x double];
    lambda = [[x square] multiplyIntValue:3];
    t = [e multiply:x2];
    t = [t multiply:z];
    lambda = [lambda add:t];
    lambda = [lambda add:[z square]];
    lambda = [lambda divide:[[[a multiply:y] multiply:z] double]];
    u = [[[a multiply:[lambda square]] subtract:e] subtract:x2];
    v = [[y negate] subtract:[lambda multiply:[u subtract:x]]];
    return [p X:u Y:v Z:[u one]];
  }
}

- addpoint:p to:q
{
  id u,v;
  id lambda;
  id px,py,pz;
  id qx,qy,qz;

  if ([p isZero]) return q;
  if ([q isZero]) return p;
  if ([p isEqual:q]) return [self doublepoint:p];

  pz = [p Z]; px = [p X]; py = [p Y];
  qz = [q Z]; qx = [q X]; qy = [q Y];

  if ([qx isEqual:px] && [qy isOpposite:py]) {
    return [p zero];
  } else {
    lambda = [[qy subtract:py] divide:[qx subtract:px]];
    u = [[[[a multiply:[lambda square]] subtract:e] subtract:px] subtract:qx];
    v = [[py negate] subtract:[lambda multiply:[u subtract:px]]];
    return [p X:u Y:v Z:[u one]];
  }
}

@end

