
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef QUOTIENTFIELD_H

#include <cakit.h>

@interface QuotientField : CAObject
{
  id value;
  id nonsquare;
  id modulus;
}

+ value:v modulus:p;
+ int:(int)x modulus:(unsigned short)aPrime;
- intValue:(int)v;

- nonsquare;

- value;
- value:x;

- one;
- zero;

- (BOOL)isOne;
- (BOOL)isMinusOne;
- (BOOL)isZero;

- negate;
- double;
- add:x;
- subtract:x;
- square;
- multiply:x;
- inverse;
- divide:x;

@end

#define QUOTIENTFIELD_H
#endif

