
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ProjectivePoint.h"
#include "EllipticCurve.h"

@implementation ProjectivePoint

+ X:X Y:Y
{
  return [self X:X Y:Y Z:[X one]];
}

- setX:X Y:Y Z:Z
{
  x = X;y = Y;z = Z;return self;
}

+ X:X Y:Y Z:Z
{
  return [[super new] setX:X Y:Y Z:Z];
}

- (unsigned)hash
{
  unsigned h = [z hash];
  if (h==0) return h; return ([x hash] ^ [y hash]) / h; 
}

/* projective equality */

- (BOOL)isEqual:b
{
  if (self == b) {
    return YES;
  } else {
    id bz = [b Z];
    if (z == bz || [z isEqual:bz]) {
       return [x isEqual:[b X]] && [y isEqual:[b Y]];
    } else {
       return [[x multiply:bz] isEqual:[[b X] multiply:z]] &&
              [[y multiply:bz] isEqual:[[b Y] multiply:z]];
    }
  }
}

- (BOOL)isOpposite:b
{
  return [[self negate] isEqual:b];
}
  
- X:X Y:Y
{
  return [[super copy] setX:X Y:Y Z:z];
}
   
- X:X Y:Y Z:Z
{
  return [[super copy] setX:X Y:Y Z:Z];
}

- X
{
  return x;
}

- Y
{
  return y;
}

- Z
{
  return z;
}

- printOn:(IOD)d
{
  fprintf(d,"(");
  [x printOn:d];
  fprintf(d,",");
  [y printOn:d];
  fprintf(d,",");
  [z printOn:d];
  fprintf(d,")");
  return self;
}

- sendOn:(int)fd
{
  [x sendOn:fd];
  [y sendOn:fd];
  return self;
}

- receiveFrom:(int)fd
{
  id p,q;
  p = [x receiveFrom:fd];
  q = [y receiveFrom:fd];
  return [[super copy] setX:p Y:q Z:[p one]];
}

@end

