
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PROJECTIVEPOINT_H

#include <cakit.h>

@interface ProjectivePoint : CAObject
{
  id x,y,z; /* coordinates in projective plane */
}

+ X:X Y:Y;
+ X:X Y:Y Z:Z;
- copy;

- X:X Y:Y;
- X:X Y:Y Z:Z;

- X;
- Y;
- Z;

- sendOn:(int)fd;
- receiveFrom:(int)fd;

@end

#define PROJECTIVEPOINT_H
#endif

