
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "PointOfCurve.h"
#include "EllipticCurve.h"

@implementation PointOfCurve

- curve:aCurve
{
  curve = aCurve;return self;
}

- curve
{
  return curve;
}

- asBigInt
{
  return [curve pointAsBigInt:self];
}

- zero
{
  return [self X:[x zero] Y:[x one] Z:[x zero]];
}

- (BOOL)isZero
{
  return [z isZero];
}

- negate
{
  return [curve negatepoint:self];
}

- double
{
  return [curve doublepoint:self];
}

- checkcurve:b
{
  if ([b curve] != curve) [self error:"curve must be the same"];  
  return self;
}

- add:b
{
  [self checkcurve:b]; return [curve addpoint:self to:b];
}

- subtract:b
{
  [self checkcurve:b]; return [curve subtractpoint:b from:self];
}

- multiply:n
{
  if ([self isZero] || [n isZero]) return [self zero];
  return [curve multiplypoint:self by:n];
}

- multiplyIntValue:(int)n
{
  id e;
  if (n==0 || [self isZero]) return [self zero];
  e = [BigInt int:(n<0)?-n:+n];
  return (n<0)?[curve multiplypoint:[self negate] by:e]:[curve multiplypoint:self by:e];
}

- printOn:(IOD)d
{
  BOOL oncurve;
  [super printOn:d];
  oncurve = [curve includes:self]; 
  fprintf(d,(oncurve)?" (on curve)":" (NOT on curve)");
  return self;
}

@end

