
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "EllipticCurve.h"
#include "PointOfCurve.h"
#include "BigIntModp.h"

#include  <ordcltn.h>

int printdots;

@implementation EllipticCurve 

- pointAsBigInt:aPoint
{
  id x = [aPoint X]; return [x asBigInt];
}

- xembed:aString
{
  return [self subclassResponsibility];
}

- (int)countatx:x
{
  [self subclassResponsibility];
  return 0;
}

- pointatx:x
{
  return [self subclassResponsibility];
}

- embed:aString
{
  id p;
  id x = [self xembed:aString];
  while ((p = [self pointatx:x]) == nil) {
    x = [x increment];
  }
  return p;
}

- evalrhs:x:z
{
  id x2;
  id z2;
  id sum = [x zero];

  x2 = [x square];
  z2 = [z square];

  if (g) sum = [sum add:[g multiply:[z2 multiply:z]]];
  if (f) sum = [sum add:[f multiply:[x multiply:z2]]];
  if (e) sum = [sum add:[e multiply:[x2 multiply:z]]];
  if (d) sum = [sum add:[d multiply:[x2 multiply:x]]];

  return sum;
}

- evallhs:x:y:z
{
  id y2;
  id z2;
  id sum = [y zero];

  y2 = [y square];
  z2 = [z square];

  if (c) sum = [sum add:[c multiply:[z2 multiply:y]]];
  if (b) sum = [sum add:[b multiply:[[x multiply:z] multiply:y]]];
  if (a) sum = [sum add:[a multiply:[y2 multiply:z]]];

  return sum;
}

- (BOOL)includes:point
{
  id x,y,z;
  id lhs,rhs;
  x = [point X];
  y = [point Y];
  z = [point Z];
  lhs = [self evallhs:x:y:z];
  rhs = [self evalrhs:x:z];
  return [lhs isEqual:rhs];
}

- negatepoint:p
{
  return [self subclassResponsibility];
}

- doublepoint:p
{
  return [self subclassResponsibility];
}

- addpoint:p to:q
{
  return [self subclassResponsibility];
}

- subtractpoint:q from:p
{
  return ([p isEqual:q])?[p zero]:[p add:[q negate]];
}

- multiplypoint:q by:n
{
  int i;
  id o,ev;
  DIGIT rem;
  static id cache,cachep;

  if (cachep!=q) { cachep=q;cache=[OrdCltn new]; }
 
  if ([q isZero]) {
    return q;
  }
  if ([n sign] < 0) {
    return [self multiplypoint:[q negate] by:[n negate]];
  }
  o = [q zero];
  ev = q;
  i = 0;
  while ([n notOne]) {
   if (printdots) { printf(".");fflush(stdout); }
   n = [n quotientDigit:2 remainder:&rem];
   if (rem) {
     o = [o add:ev];
   } 
   if (i < [cache size]) {
     ev = [cache at:i];
   } else {
     ev = [ev double];
     [cache add:ev];
   }
   i++;
  }
   
  return [ev add:o];
}

#define PLC(y) if ([y notOne]) [y printOn:x]
#define PLS(y) if (![y printsLeadingSign]) fprintf(x,"+");PLC(y)

- printOn:(IOD)x
{
  if ([a notZero]) { PLC(a); fprintf(x," Y^2 Z "); }
  if ([b notZero]) { PLS(b); fprintf(x," X Y Z "); }
  if ([c notZero]) { PLS(c); fprintf(x," Y Z^2 "); }
  fprintf(x," == ");
  if ([d notZero]) { PLC(d);fprintf(x," X^3 "); }
  if ([e notZero]) { PLS(e); fprintf(x," X^2 Z "); }
  if ([f notZero]) { PLS(f); fprintf(x," X Z^2 "); }
  if ([g notZero]) { PLS(g); fprintf(x," Z^3 "); }
  return self;
}

- simpleorder /* can only be used for small fields */
{
  id x;
  unsigned n = 1;
  id q = [a cardinality];
  x = [a zero];
  do {
    n += [self countatx:x];
    x = [x increment];
  } while ([x notZero]);
  return [BigInt int:n];
}

- orderDegree:(int)n
{
   int i;
   id cc,c0,c1,c2;
   id q = [a cardinality];

   c0 = [BigInt int:2];
   cc = (c1 = [[q increment] subtract:[self simpleorder]]);

   for(i=1;i<n;i++) {
     c2 = [[cc multiply:c1] subtract:[q multiply:c0]]; 
     c0 = c1;
     c1 = c2;
   }
   
   return [[[q power:n] increment] subtract:c1]; 
}

@end

