
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef ELLIPTICCURVE_H

#include "PlainCurve.h"

extern int printdots;

@interface EllipticCurve : PlainCurve
{
  id a; // y^2 z 
  id b; // x y z
  id c; // y z^2
  id d; // x^3 
  id e; // x^2 z 
  id f; // x z^2 
  id g; // z^3
}

- embed:aBigInt;
- pointAsBigInt:aPoint;

- pointatx:x;
- (int)countatx:x;
- xembed:aBigint;

- negatepoint:p;
- doublepoint:p;
- addpoint:p to:q;
- subtractpoint:q from:p;
- multiplypoint:q by:n;

- pointatx:x;
- evallhs:x:y:z;
- evalrhs:x:z;

/* order of curve by simple counting */
- simpleorder;

/* order of curve over extension field of degree 'n' */
- orderDegree:(int)n;

@end

#define ELLIPTICCURVE_H
#endif

