
/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "BigIntModp.h"
#include "Legendre.h"
#include "Shanks.h"
#include "Bezout.h"

#include <ocstring.h>

@implementation BigIntModp

- (BOOL)inField
{
  return YES;
}

- cardinality
{
  return modulus;
}

+ int:(int)x modulus:(unsigned short)p
{
  return [self value:[BigInt int:x] modulus:[BigInt int:p]];
}

- asBigInt
{
  return value;
}

- embed:aBigInt
{
  if ([aBigInt isGreaterEqual:modulus]) {
    [self error:"Modulus not large enough to contain data"];
  } else {
    return [[self copy] value:aBigInt];
  }
}

- printOn:(IOD)d
{
  [value printOn:d];
  return self;
}

- (BOOL)isSquare
{
   return [self isZero] || [self isOne] || legendre(value,modulus) == +1;
}

- findnonsquare
{
  /* p mod 4 == 1 */
  nonsquare = [[value one] negate];
  if (legendre(nonsquare,modulus) == -1) return self;
  nonsquare = [[value one] double];
  while (legendre(nonsquare,modulus) == +1) {
    nonsquare = [nonsquare increment];
  }
  return self;
}

- squareRoot
{
  if ([self isOne]) return self;
  if ([self isZero]) return self;
  if (!nonsquare) [self findnonsquare];
  return [[super copy] value:shanks(value,modulus,modulus,nonsquare)]; 
}

- frobenius
{
  return self;
}

@end

