//#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+   
//#+     Mumps Compiler 
//#+     Copyright (C) 2000 by Kevin C. O'Kane  
//#+
//#+     Kevin C. O'Kane
//#+     Department of Computer Science
//#+     University of Northern Iowa
//#+     Cedar Falls, IA 50613-0507 USA
//#+
//#+     okane@cs.uni.edu
//#+     anamfianna@earthlink.net
//#+     http://www.cs.uni.edu/~okane
//#+
//#+
//#+ This program is free software; you can redistribute it and/or modify
//#+ it under the terms of the GNU General Public License as published by
//#+ the Free Software Foundation; either version 2 of the License, or
//#+ (at your option) any later version.
//#+ 
//#+ This program is distributed in the hope that it will be useful,
//#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
//#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//#+ GNU General Public License for more details.
//#+ 
//#+ You should have received a copy of the GNU General Public License
//#+ along with this program; if not, write to the Free Software
//#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+ This software is covered by the GPL - Not the LGPL.
//#+
//#+ A consequence of this is that if this code is incorporated
//#+ into another work, it causes that work to become covered by
//#+ the GNU GPL license. 
//#+
//#+ Contact the author for other licensing arrangements.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+
//#+    Some of this code was originally written in Fortran
//#+    which will explain the odd array and label usage,
//#+    especially arrays beginning at index 1.
//#+
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#include "memsize.h"

#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#if UNIX==0
#include <conio.h>
#include <io.h>
#include <dos.h>
#include <errno.h>
#include <bios.h>
#endif

#define SymStore 0
#define SymRetrieve 1
#define SymDeleteExplicit 2
#define SymNext 3
#define SymDeleteAll 4
#define SymDeleteAllExcept 5
#define SymData 6

#define RETRIEVE 0
#define STORE 1
#define NEXT 2
#define XNEXT 8
#define NEXTX 20
#define KILL1 30

#define JOB 0
#define SET 1
#define GOTO 2
#define WRITE 3
#define IF 4
#define ZCMDS 6
#define READ 7
#define QUIT 8
#define XECUTE 9
#define TAB 9
#define FOR 10
#define HALT 11
#define ELSE 12
#define DO 13
#define KILL 14
#define CLOSE 15
#define USE 16
#define LOCK 17
#define COMMENT 18
#define BREAK 19
#define BADCMD 21
#define KILL2 20
#define FCN 20
#define LBL 21
#define QUOTE '\''
#define OPEN 0
#define DIVIDE 1
#define MULTIPLY 2
#define MINUS 3
#define PLUS 4
#define OPERAND 5
#define OPENC 6
#define CONCAT 7
#define EQUALS 8
#define GREATER 9
#define EMPTY 10
#define LESSTHAN 11
#define NOT 12
#define INTDIVIDE 13
#define MODULO 14
#define CONTAINS 15
#define FOLLOWS 16
#define PATTERN 17
#define NOTEQ 18
#define NOTGREATER 19
#define NOTLESS 20
#define NOTCONTAINS 21
#define NOTFOLLOWS 22
#define NOTPATTERN 23
#define AND 24
#define OR 25
#define NOTAND 26
#define NOTOR 27
#define INDIRECT 28
#define EXPONEN 29
#define PREDICATEVAR '~'
#define CodedOpen 206
#define CodedClose 207
#define CodedComma 208
#define CodedColon 209

#include "externs.h"

extern short MaxTmp;

/*--------------*/

void patrn (unsigned char *);
void patrn1 (short *, short *);
int xindex (unsigned char *, unsigned char *, short);
void errmod_ (short msgnbr, unsigned char text[], FILE * opnfile[]);
void memcheck (int);
void add (char *a, char *b, char *c);
void sub (char *a, char *b, char *c);
void mult (char *a, char *b, char *c);
void divx (char *a, char *b, char *c);
int numcomp (char aa[], char bb[]);
void cannon (char a[]);
int sym_ (int, unsigned char a[], unsigned char b[]);
short keyfix (unsigned char *);
void fixstr (unsigned char[]);
extern FILE *Out;

/*--------------*/

parse_ ()
  /* 206 = open; 207 = close; 208 = comma; 209 = colon; */
{
  short ernbr, f, spx, adx, jpx, j, i, g, iiitmp = 0;
  static unsigned char cod209[2] = { 209, 0 };
  static unsigned char s1p[40];
  unsigned char bbtyp, nxtchr;
  unsigned char *bp = &bd[1];
  unsigned char *v1dp = &v1d[1];

  static unsigned char code[26] = {
      /*0*/ 99, 99, 99, 99, 99, 99, 99, 99, 18, 19,
      /*10*/ 99, 20, 18, 99, 99, 21, 22, 23, 99, 99,
      /*20*/ 99, 99, 99, 99, 26, 27
      };

  static unsigned char opcode[256] = {
      /*0*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*10*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*20*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*30*/ 99, 99, 99, 25, 99, 14, 99, 99, 24, 12,
      /*40*/ 0, 99, 2, 4, 99, 3, 99, 1, 99, 99,
      /*50*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*60*/ 11, 8, 9, 17, 28, 99, 99, 99, 99, 99,
      /*70*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*80*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*90*/ 99, 15, 13, 16, 99, 7, 99, 99, 99, 99,
      /*100*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*110*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*120*/ 99, 99, 99, 99, 99, 99, 99, 99
      };

  static unsigned char ncode[256] = {
      /*0*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*10*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*20*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*30*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*40*/ 99, 99, 99, 99, 99, 99, 10, 99, 10, 10,
      /*50*/ 10, 10, 10, 10, 10, 10, 10, 10, 99, 99,
      /*60*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*70*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*80*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*90*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*100*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*110*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*120*/ 99, 99, 99, 99, 99, 99, 99, 99
      };


  static unsigned char dcode[256] = {
      /*0*/ 10, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*10*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*20*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*30*/ 99, 99, 10, 10, 99, 10, 99, 99, 10, 10,
      /*40*/ 99, 10, 10, 10, 10, 10, 99, 10, 99, 99,
      /*50*/ 99, 99, 99, 99, 99, 99, 99, 99, 10, 99,
      /*60*/ 10, 10, 10, 10, 10, 99, 99, 99, 99, 99,
      /*70*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*80*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*90*/ 99, 10, 10, 10, 99, 10, 99, 99, 99, 99,
      /*100*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*110*/ 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
      /*120*/ 99, 99, 99, 99, 99, 99, 99, 99
      };

  static unsigned char operand[256] = {
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0, 1, 1, 2, 0,
      0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
      2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 2, 1, 0, 0, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 0, 0, 0, 0, 0
      };

//*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+                                                               +
//+       initialization                                          +
//+                                                               +
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  xpx--;
  spx = 0;
  pd1[pd1len + 2] = 0;
  pd1[pd1len + 3] = 0;
  sdlim = pd1len + 3;

//*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+                                                               +
//+       main recursive internal entry point                     +
//+                                                               +
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

start:

      spx++;
      s1p[spx] = EMPTY; /*stack foundation */

nchar:

      if ((nxtchr = xd[++xpx]) == 0) goto finish;

      if (operand[nxtchr] == 1) goto scan_operand;

      if (nxtchr == CodedOpen) {

            unsigned char *p1, *p2;

            spx++;
            while (pd1[sdlim++]);
            if (sdlim >= symlen) return (31);
            p1 = &v1d[1];
            p2 = &pd1[sdlim];
            while (*p2++ = *p1++);
            *p2 = 0;
            p2--;
            *p2 = CodedOpen;
            s1p[spx] = OPENC;
            goto nchar;
            }

      if (nxtchr == ',') {

            if (s1p[spx - 1] != OPENC) {
                  if (t2 > 0) goto finish;
                  return (16);
            	}

            //*===========================================
            //* concatenate stack tops and add coded comma    
            //*===========================================

            for (i = --sdlim; (pd1[i] = pd1[i + 1]); i++);	//* join tops 

            pd1[i] = CodedComma;
            pd1[i + 1] = 0;		                        //* coded comma 
            sdlim--;
            while (pd1[sdlim--]);                     	//* find new stack top start 
            sdlim += 2;
            spx--;			                        //* stack pointer 
            goto nchar;
            }

      if (nxtchr == ')') {

            if (s1p[spx - 1] != OPEN) {
                  if (s1p[spx - 1] != OPENC) return (16);

                  //*===========================================
                  //* fcn/array return section
                  //*===========================================

                  sdlim--;
                  for (i = sdlim; (pd1[i] = pd1[i + 1]); i++);    	//*join tops 
                  pd1[i] = CodedClose;
                  pd1[i + 1] = 0;	                                    //* coded close 
                  sdlim--;
                  while (pd1[sdlim--]);	                              //* find new stack top start 
                  sdlim += 2;
                  spx--;		/* stack pointer */
                  goto un_nest;
                  }

      //*===========================================
      //* precedence close paren 
      //*===========================================

      if (s1p[spx] != OPERAND)
	return (12);

      //*===========================================
      //* extract value from stack top 
      //*===========================================

      strcpy (bp, &pd1[sdlim]);

      do sdlim--; while (pd1[sdlim - 1]);	      //*compress stack 

      goto dec_stk;
      }

  if (nxtchr == ':') {

      i = sdlim;

      do i--; while (pd1[i - 1]);

      if (pd1[i] != '$' || tolower (pd1[i + 1]) != 's') goto finish;

      sdlim--;
      strcpy (&pd1[sdlim], &pd1[sdlim + 1]);

      while (pd1[sdlim--]);

      sdlim += 2;
      strcat (&pd1[sdlim], cod209);
      spx--;
      goto nchar;
      }

  if (nxtchr == ' ' || nxtchr == '\t') goto finish;

  if (nxtchr == '^' && t2 == 2 && s1p[spx] == OPERAND) goto finish;

///*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+                                                               
//+       check for delimiters in list                            
//+                                                               
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  spx++;

  if (nxtchr == QUOTE) {      //* insert not based operator code 
      xpx++;
      s1p[spx] = opcode[xd[xpx]];
      if (s1p[spx]!=99) {
            s1p[spx] = code[opcode[xd[xpx]]];
            if (s1p[spx] != 99) goto nchar;
            }
      xpx--;
      }

  if (nxtchr == '*' && xd[xpx + 1] == '*') { //* exponentiation code 
      xpx++;
      s1p[spx] = EXPONEN;
      goto nchar;
      }

//*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+                                                               
//+       insert code                                             
//+                                                               
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

  s1p[spx] = opcode[nxtchr];
  if (s1p[spx] != 99) goto nchar;
  return (12);

//*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+                                                               
//+       scan for operand                                        
//+                                                               
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

scan_operand:

  jpx = xpx;

  if (s1p[spx] == NOTPATTERN || s1p[spx] == PATTERN) {
      bd[1] = 0;
      patrn1 (&jpx, &ernbr);
      if (ernbr)
	return (ernbr);
      goto exec;
      }

//*==========================
// numeric operand
//*==========================

  if (ncode[xd[xpx]] == 10) {

      for (i = 1; (bd[i] = xd[xpx]) && ncode[bd[i]] == 10; (i++, xpx++) );

      if (i == 1 && bd[1] == '.') return (9);
      bd[i] = 0;
      cannon (bp);

            {
            char t[512];
            t[0] = '\"';
            strcpy (&t[1], &bd[1]);
            strcat (t, "\"");
            strcpy (&bd[1], t);
            }

      xpx--;
      goto exec;
    }

//*==========================
// literal operand
//*==========================

  if (xd[xpx] == '"') {

      j = 0;
      bd[++j] = '\"';

      while (1) {

            while (xd[++xpx] != '"') {

                  if (xd[xpx] == '\\') {
                        bd[++j] = '\\';
                        bd[++j] = '\\';
                        continue;
                        }

	            if (xd[xpx] == '\'') {
                        bd[++j] = '\\';
                        bd[++j] = '\'';
                        continue;
                        }

	            if ((bd[++j] = xd[xpx]) == 0)
		      return (2);
	            }

            if (xd[xpx + 1] != '"') {
                  bd[++j] = '\"';
                  bd[++j] = 0;
                  goto exec;
                  }

            xpx++;
            bd[++j] = '\\';
            bd[++j] = '\"';
            }
      }

//*==========================
// variable name
//*==========================

  v1d[1] = xd[xpx++];
  j = 2;

  while (1) {

      if (dcode[xd[xpx]] == 10) {
            v1d[j] = 0;
            xpx--;
            goto var1;
            }

      v1d[j++] = xd[xpx];

      if (xd[xpx] == '(') {
            v1d[--j] = 0;
            xd[xpx--] = CodedOpen;
            goto start;		            //* recurse 
            }
      xpx++;
    }

un_nest:			                  //* copy answer from stack 

  while (pd1[--sdlim]);
  strcpy (v1dp, &pd1[sdlim + 1]);
  while (pd1[--sdlim]);
  sdlim++;
  spx -= 2;

var1:

      if (t0px == 1 && spx == 1) {
            spx--;
            t0px = 0;
            return (0);
            }

//* Deprecated code
//  if (pd1[sdlim] == '$' && t0px == 1 &&
//      (pd1[sdlim + 1] == 'P' || pd1[sdlim + 1] == 'p'))     ;
//            if (setname[0] == 0) strcpy (setname, v1dp); 
//          if (setname[0] == 0) sprintf(setname,"tmp%d",iiitmp);

  if (v1d[1] == '^') {                    //* global var 

      g = RETRIEVE;

      if (pd1[sdlim] == '$' && s1p[spx] != INDIRECT) {

            if (toupper (pd1[sdlim + 1]) == 'N' ||
	                   (pd1[sdlim + 1]) == 'O') g = NEXT;

            }

//*=============================
//  build global array reference
//*=============================

      fprintf (Out, "\tg=%d;\n", g);

            {
	      char t[1024];
	      int i, j = 0;

	      for (i = 1; v1d[i] != 0; i++) {
	            if (v1d[i] >= 32 && v1d[i] <= 127) t[j++] = v1d[i];
	            else break;
	            }

	      t[j++] = '\\';
	      t[j++] = 'x';
	      t[j++] = '0';
	      t[j++] = '1';
	      t[j] = 0;

	      fprintf (Out, "\tstrcpy(gtmp,\"%s\");\n", t);
	      i++;

	      while (1) {
	            j = 0;
	            while (v1d[i] <= 127 && v1d[i] >= 32) t[j++] = v1d[i++];
	            t[j] = 0;
	            fprintf (Out, "\tstrcatx(gtmp,%s);\n", t);
	            if (v1d[++i] != 0) continue;
	            else break;
	            }

	      fprintf (Out, "\tstrcpy(tmp%d,gtmp);\n", iiitmp, t);
            }

      iiitmp++;
      memcheck (iiitmp);
      fprintf (Out, "\tstrcpy(tmp,tmp%d);\n",iiitmp-1);
      fprintf (Out, "\tf=global(g,tmp%d,tmp%d);\n", iiitmp - 1, iiitmp);
      sprintf(setname,"tmp");
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      f = 1;

//*==============================
// fix $order end string 
//*==============================

      if (toupper (pd1[sdlim + 1]) == 'O')
	      if (strcmp (bp, "-1") == 0) bd[1] = 0; //* empty 

//*==============================================================
//*                                                               
//*       check returned result for $data  
//*                                                               
//*==============================================================

      if (pd1[sdlim] == '$' && (pd1[sdlim + 1] == 'D' || pd1[sdlim + 1] == 'd')) {

            if (pd1[sdlim + 2] == 'x') {        //* special $d 
	            if (f == 0) bd[1] = '0';
	            else bd[1] = '1';
	            bd[2] = 0;
	            goto exec;
	            }

            fprintf (Out, "\tif (!f) {\n");

	      fprintf (Out, "\t\ti=strlen(tmp%d);\n", iiitmp - 2);	// i=strlen(T)
	      fprintf (Out, "\t\ttmp%d[i]=2;\n", iiitmp - 2);
	      fprintf (Out, "\t\ttmp%d[i+1]=0;\n", iiitmp - 2);
	      fprintf (Out, "\t\tf=global(NEXT,tmp%d,tmp%d);\n", iiitmp - 2, iiitmp - 1);
	      fprintf (Out, "\t\tif (f==1)\n");
	      fprintf (Out, "\t\t\tstrcpy(tmp%d,\"10\");\n", iiitmp);
	      fprintf (Out, "\t\t\telse strcpy(tmp%d,\"0\");\n", iiitmp);
	      fprintf (Out, "\t\t}\n");

	      fprintf (Out, "\telse {\n\t\tstrcpy(tmp%d,\"1\");\n", iiitmp);
	      fprintf (Out, "\t\ti=strlen(tmp%d);\n", iiitmp - 2);
	      fprintf (Out, "\t\ttmp%d[i]=2;\n", iiitmp - 2);
	      fprintf (Out, "\t\ttmp%d[i+1]=0;\n", iiitmp - 2);
	      fprintf (Out, "\t\tf=global(NEXT,tmp%d,tmp%d);\n", iiitmp - 2, iiitmp - 1);
	      fprintf (Out, "\t\tif (f==1)\n");
	      fprintf (Out, "\t\t\tstrcat(tmp%d,\"1\");\n", iiitmp);
	      fprintf (Out, "\t\t\t}\n", iiitmp);

	      sprintf (&bd[1], "tmp%d", iiitmp);
	      iiitmp++;
	      memcheck (iiitmp);
	      goto exec;
	      }

      tpx = f;
      goto exec;
      }                 //* normal global 

//*==============================================================
//*                                                               
//*       built-in variables/fcns                                 
//*                                                               
//*==============================================================

  if (v1d[1] == '$') {

      if (v1d[2] == 'd' || v1d[2] == 'n' ||
          v1d[2] == 'o' || v1d[2] == 'O' || 
          v1d[2] == 'D' || v1d[2] == 'N') {

	      for (i = 1; v1d[i] != CodedOpen; i++);	      //* open 
	      j = 0;
	      while ((bd[++j] = v1d[++i]) != CodedClose);	//* close 
	      bd[j] = 0;
	      goto exec;
	      }

      if (v1d[2] == '$') goto no_arg;

//*========
//* $test 
//*========

      if (strcasecmp (&v1d[1], "$test") == 0 ||
          strcasecmp (&v1d[1], "$t") == 0) {

	  fprintf (Out, "\tif (tpx) tmp%d[0]=\'1\'; " "/* $test */\n", iiitmp);
	  fprintf (Out, "\telse tmp%d[0]=\'0\';\n", iiitmp);
	  fprintf (Out, "\ttmp%d[1]=\'\\0\';\n", iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  goto exec;
	  }

//*========
//* $io   
//*========

      if (strcasecmp (&v1d[1], "$io") == 0 || strcasecmp (&v1d[1], "$i") == 0) {

	  fprintf (Out, "\tsprintf(tmp%d,\"%%d\",io);" " /* $io */\n", iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  goto exec;
	  }

//*========
//* $x    
//*========

      if (strcasecmp (&v1d[1], "$x") == 0 || strcasecmp (&v1d[1], "$x") == 0) {

	  fprintf (Out, "\tsprintf(tmp%d,\"%%d\",hor[io]);" " /* $x */\n", iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  goto exec;
	  }

//*=========
//* $y   
//*=========

      if (strcasecmp (&v1d[1], "$y") == 0 || strcasecmp (&v1d[1], "$y") == 0) {

	  fprintf (Out, "\tsprintf(tmp%d,\"%%d\",ver[io]);" " /* $y */\n", iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  goto exec;
	  }

//*=========
//* $h    
//*=========

      if (strcasecmp (&v1d[1], "$horolog") == 0 ||
          strcasecmp (&v1d[1], "$h") == 0) {

	  fprintf (Out, "\t_horolog(tmp%d);" " /* $h */\n", iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  goto exec;
	  }

//*=========
//* $char 
//*=========

      if (strncasecmp (&v1d[1], "$char", 5) == 0 ||
          strncasecmp (&v1d[1], "$c", 2) == 0) {

	  int i, j;
	  char tmp[1024];

	  for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn nme 
	  strcpy (v1d, &v1d[i + 1]);	                        //* remove function name 
	  fprintf (Out, "\t_j=0;\n");
	  i = 0;

      while (1) {
            j = i;
            for (; v1d[i] >= 32 && v1d[i] <= 127; i++);

            if (v1d[i] == 0) {
                  fprintf (Out, "\ttmp%d[_j]=0;\n", iiitmp + 1);
                  sprintf (bp, "tmp%d", iiitmp + 1);
                  iiitmp++;
                  memcheck (iiitmp);
                  goto exec;
                  }

            v1d[i++] = 0;
            fprintf (Out, "\tstrcpy(tmp%d,%s);\n", iiitmp, &v1d[j]);
            fprintf (Out, "\tcannon(tmp%d);\n", iiitmp);
            fprintf (Out, "\ti=atol(tmp%d);\n", iiitmp);
            fprintf (Out, "\tif (i>0) ");
            fprintf (Out, "\ttmp%d[_j++]=i;\n", iiitmp + 1);
            }
      }

//*============
//* $FNumber 
//*============

      if (strncasecmp (&v1d[1], "$fnumber", 5) == 0 ||
          strncasecmp (&v1d[1], "$fn", 3) == 0) {

            int i, j, r, a;
            char tmp[1024];

            for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn nme 

            strcpy (v1d, &v1d[i + 1]);	                        //* remove function name 
            i = 0;
            a = 0;
            strcpy (tmp, "");

            while (1) {
                  j = i;
                  for (; v1d[i] >= 32 && v1d[i] <= 127; i++);
                  if (v1d[i] == 0) {
                        if (a == 0 || a > 3) return (a);
                        fprintf (Out, "\t_fnumber(" "tmp%d,%s);\n", iiitmp, tmp);
                        sprintf (bp, "tmp%d", iiitmp);
                        iiitmp++;
                        memcheck (iiitmp);
                        goto exec;
                        }

	      v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
      }

//*============
//* $extract 
//*============

      if (strncasecmp (&v1d[1], "$extract", 5) == 0 ||
          strncasecmp (&v1d[1], "$e", 2) == 0) {

	  int i, j, r, a;
	  char tmp[1024];

	  for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn nme 

	  strcpy (v1d, &v1d[i + 1]);	                        //* remove function name 
	  i = 0;
	  a = 0;
	  strcpy (tmp, "");

	  while (1) {
	      j = i;
	      for (; v1d[i] >= 32 && v1d[i] <= 127; i++);

	      if (v1d[i] == 0) {
		  if (a == 0 || a > 3) return (a);
		  if (a == 1) strcat (tmp, ",\"-1\",\"-1\"");
		  else if (a == 2) strcat (tmp, ",\"-1\"");
		  fprintf (Out, "\t_extract(" "tmp%d,%s);\n", iiitmp, tmp);
		  sprintf (bp, "tmp%d", iiitmp);
		  iiitmp++;
		  memcheck (iiitmp);
		  goto exec;
		  }

	      v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
      }

//*============
//* $length  
//*============

      if (strncasecmp (&v1d[1], "$length", 5) == 0 ||
          strncasecmp (&v1d[1], "$l", 2) == 0) {

	  int i, j, r, a;
	  char tmp[1024];

	  for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn nme 
	  strcpy (v1d, &v1d[i + 1]);	                        //* remove function name 
	  i = 0;
	  a = 0;
	  strcpy (tmp, "");

	  while (1) {

	      j = i;
	      for (; v1d[i] >= 32 && v1d[i] <= 127; i++);

	      if (v1d[i] == 0) {
                  if (a == 0 || a > 3) return (a);
                  if (a == 1) strcat (tmp, ",\"\"");
                  fprintf (Out, "\t_length(" "tmp%d,%s);\n", iiitmp, tmp);
                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  goto exec;
                  }

	      v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
	}

//*============
//* $find    
//*============

      if (strncasecmp (&v1d[1], "$find", 5) == 0 ||
          strncasecmp (&v1d[1], "$f", 2) == 0) {

	  int i, j, r, a;
	  char tmp[1024];

	  for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn name
	  strcpy (v1d, &v1d[i + 1]);	                        //* remove function name 
	  i = 0;
	  a = 0;
	  strcpy (tmp, "");

	  while (1) {
	      j = i;
	      for (; v1d[i] >= 32 && v1d[i] <= 127; i++);
	      if (v1d[i] == 0) {
                  if (a == 0 || a > 3) return (a);
                  if (a == 2) strcat (tmp, ",\"-1\"");
                  fprintf (Out, "\t_find(" "tmp%d,%s);\n", iiitmp, tmp);
                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  goto exec;
                  }

	      v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
	}


//*============
//* $ascii   
//*============

      if (strncasecmp (&v1d[1], "$ascii", 5) == 0 ||
          strncasecmp (&v1d[1], "$a", 2) == 0) {

	  int i, j, r, a;
	  char tmp[1024];

	  for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn nme 
	  strcpy (v1d, &v1d[i + 1]);	                        //* remove function name 
	  i = 0;
	  a = 0;
	  strcpy (tmp, "");

	  while (1) {
	      j = i;
	      for (; v1d[i] >= 32 && v1d[i] <= 127; i++);

	      if (v1d[i] == 0) {
                  if (a == 0 || a > 2) return (a);
                  if (a == 1) strcat (tmp, ",\"-1\"");
                  fprintf (Out, "\t_ascii(" "tmp%d,%s);\n", iiitmp, tmp);
                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  goto exec;
                  }
	      v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
      }

//*============
//* $justify 
//*============

      if (strncasecmp (&v1d[1], "$justify", 5) == 0 ||
          strncasecmp (&v1d[1], "$job", 4) == 0 ||
          strncasecmp (&v1d[1], "$j", 2) == 0) {

	  int i, j, r, a;
	  char tmp[1024];

	  for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn name 

	  if (v1d[i] == 0) strcpy (v1d, "");
	  else strcpy (v1d, &v1d[i + 1]);	                  //* remove function name 

	  i = 0;
	  a = 0;
	  strcpy (tmp, "");

	  while (1) {
	      j = i;
	      for (; v1d[i] >= 32 && v1d[i] <= 127; i++);

	      if (v1d[i] == 0) {
                  if (a == 0) { //* $job 
                        fprintf (Out, "\tsprintf(tmp%d,\"%%d\",getpid());\n", iiitmp);
                        }

                  else {
                        if (a == 1 || a > 3) return (a);
                        if (a == 2) strcat (tmp, ",\"-1\"");
                        fprintf (Out, "\t_justify(" "tmp%d,%s);\n", iiitmp, tmp);
                        }

                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  goto exec;
                  }

	      v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
	}

//*============
//* $piece 
//*============

      if (strncasecmp (&v1d[1], "$piece", 6) == 0 ||
          strncasecmp (&v1d[1], "$p", 2) == 0) {

	  int i, j, r, a;
	  char tmp[1024];

	  for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn name 

	  if (v1d[i] == 0) strcpy (v1d, "");
	  else strcpy (v1d, &v1d[i + 1]);	                  //* remove function name 

	  i = 0;
	  a = 0;
	  strcpy (tmp, "");

	  while (1) {
	      j = i;
	      for (; v1d[i] >= 32 && v1d[i] <= 127; i++);

	      if (v1d[i] == 0) {
                  if (a == 1 || a > 4) return (a);
                  if (a == 2) strcat (tmp, ",\"-1\"");
                  if (a < 4) strcat (tmp, ",\"-1\"");
                  fprintf (Out, "\t_piece(tmp%d,%s,0,\"\");\n", iiitmp, tmp);
                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  goto exec;
                  }

	      v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
	}

//*============
//* $select  
//*============

      if (strncasecmp (&v1d[1], "$select", 5) == 0 ||
          strncasecmp (&v1d[1], "$storage", 4) == 0 ||
          strncasecmp (&v1d[1], "$s", 2) == 0) {

            int i, j, k = 0, r, a;
            char tmp[1024];

            for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	//* fcn name 

            if (v1d[i] == 0) strcpy (v1d, "");
            else strcpy (v1d, &v1d[i + 1]);	                  //* remove function name 

            i = 0;
            a = 0;
            strcpy (tmp, "");

            while (1) {
                  k++;
                  j = i;
	            for (; v1d[i] >= 32 && v1d[i] <= 127; i++);
	            if (v1d[i] == 0) {
                        if (a == 0) {		/* $storage */
                              fprintf (Out, "\tstrcpy(tmp%d," "\"999\");\n", iiitmp);
                              }

                  else {
                        if (k > 20)
                        return (99);

                        while (k < 21) {
                              strcat (tmp, ",");
                              strcat (tmp, "NULL");
                              k++;
                              }

		            fprintf (Out, "\t_select(" "tmp%d,%s);\n", iiitmp, tmp);
                        }

                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  goto exec;
                  }

            v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
	}

//*============
//* $random  
//*============

      if (strncasecmp (&v1d[1], "$random", 5) == 0 ||
          strncasecmp (&v1d[1], "$r", 2) == 0) {

	  int i, j, r, a;
	  char tmp[1024];

	  for (i = 1; v1d[i] >= 32 && v1d[i] <= 127; i++);	      //* fcn nme 

	  if (v1d[i] == 0) strcpy (v1d, "");
	  else strcpy (v1d, &v1d[i + 1]);	                        //* remove function name 

	  i = 0;
	  a = 0;
	  strcpy (tmp, "");

	  while (1) {
	      j = i;
	      for (; v1d[i] >= 32 && v1d[i] <= 127; i++);

	      if (v1d[i] == 0) {
                  fprintf (Out, "\t_random(tmp%d,%s);\n", iiitmp, tmp);
                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  goto exec;
                  }

	      v1d[i++] = 0;
	      if (a++)
		strcat (tmp, ",");
	      strcat (tmp, &v1d[j]);
            }
	}

//*===============================
//* build parameter list string */
//*===============================

      fprintf (Out, "\tstrcpy(&gtmp[1],\"\");\n");

      {
      	char t[1024], h[6];
	      int i, j = 0;

	      for (i = 1; v1d[i] != 0; i++) {
                  if (v1d[i] >= 32 && v1d[i] <= 127) t[j++] = v1d[i];
                  else break;
                  }

	      if (v1d[i] == 0) {
                  t[j] = 0;
                  fprintf (Out, "\tstrcat(&gtmp[1],\"%s\");\n", t);
                  goto no_arg;
                  }

	      sprintf (h, "%2x", v1d[i]);
	      t[j++] = '\\';
	      t[j++] = 'x';
	      t[j++] = h[0];
	      t[j++] = h[1];
	      t[j] = 0;
	      fprintf (Out, "\tstrcat(&gtmp[1],\"%s\");\n", t);
	      i++;

	      while (1) {
                  j = 0;
                  while (v1d[i] <= 127 && v1d[i] >= 32) t[j++] = v1d[i++];
                  t[j] = 0;
                  fprintf (Out, "\tstrcat(&gtmp[1],%s);\n", t);
                  j = 0;
                  sprintf (h, "%2x", v1d[i]);
                  t[j++] = '\\';
                  t[j++] = 'x';
                  t[j++] = h[0];
                  t[j++] = h[1];
                  t[j] = 0;
                  fprintf (Out, "\tstrcat(&gtmp[1],\"%s\");\n", t);
                  if (v1d[++i] != 0) continue;
                  else break;
                  }

no_arg:

            if (v1d[2] == 'Z' || v1d[2] == 'z') {
                  fprintf (Out, "\tzfcn(gtmp,tmp%d);\n", iiitmp);
                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  }

	      else if (v1d[2] == '$') {
                  MyFunc (&v1d[3], iiitmp);
                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  }
      
	      else {
                  fprintf (Out, "\tf=fcn(gtmp,tmp%d,tpx,io,hor,ver);\n", iiitmp);
      
                  sprintf (bp, "tmp%d", iiitmp);
                  iiitmp++;
                  memcheck (iiitmp);
                  }
            }

            if (ierr == 0) goto exec;
            return (ierr);
    }


//*===============================================================
//+       retrieve look-up                                        
//+===============================================================

  if (v1d[1] == PREDICATEVAR) {
      strcpy (bp, v1dp);
      goto exec;
      }

  {
      int i, k, j;		//* array references - insert brackets
      char tmp[1024];
      for (i = 0; v1dp[i] != 0; i++) if (v1dp[i] > 127) goto has_array;
      goto no_array;

has_array:

    fprintf (Out, "{\t // char tmp[1024]; \n\tint i;\n");

    for (i = 0; v1dp[i] != 0; i++)
      if (v1dp[i] == 206) { // Open
            v1dp[i] = 0;
            fprintf (Out, "\tstrcpy(tmp,\"%s\");\n", v1dp);
            fprintf (Out, "\ti=strlen(tmp);\n");
            fprintf (Out, "\ttmp[i]=206;\n");
            fprintf (Out, "\ttmp[i+1]=0;\n");
            v1dp[i] = 206;
            for (j = i + 1; v1dp[j] != 0; j++)
            if (v1dp[j] == 207 || v1dp[j] == 208) break;
            k = v1dp[j];
            v1dp[j] = 0;
            fprintf (Out, "\tstrcat(tmp,%s);\n", &v1dp[i + 1]);
            fprintf (Out, "\ti=strlen(tmp);\n");
            fprintf (Out, "\ttmp[i]=%d;\n", k);
            fprintf (Out, "\ttmp[i+1]=0;\n");
            v1dp[j] = k;
            i = j - 1;
            }

      else if (v1dp[i] == 207) { // Close

            if (pd1[sdlim] == '$' && s1p[spx] == OPENC &&
	         (pd1[sdlim + 1] == 'N' || pd1[sdlim + 1] == 'n' ||
	          pd1[sdlim + 1] == 'O' || pd1[sdlim + 1] == 'o'))
	            symflg = SymNext;

            else if (s1p[spx] == OPENC
		     && (pd1[sdlim + 1] == 'd' || pd1[sdlim + 1] == 'D'))
	                  symflg = SymData;

            else symflg = 1;

            fprintf (Out, "\tif (sym_(%d,tmp,tmp%d)==NULL) {\n", symflg, iiitmp);
            strcpy(setname,"tmp");
            fprintf (Out, "\t\tprintf(\"\\n*** Variable not found in or near line %%d\\n\\n\",LineNumber);\n");
            fprintf (Out, "\t\tgoto _epilogue;\n");
            fprintf (Out, "\t\t}\n");
            if (pd1[sdlim + 1] == 'N' || pd1[sdlim + 1] == 'n')
                  fprintf (Out, "\tif (strlen(tmp%d)==0) strcpy(tmp%d,\"-1\");\n", iiitmp, iiitmp);
            fprintf (Out, "\t}\n");
            break;
            }

      else if (v1dp[i] == 208) { //* comma 
            for (j = i + 1; v1dp[j] != 0; j++)
            if (v1dp[j] == 207 || v1dp[j] == 208) break;
            k = v1dp[j];
            v1dp[j] = 0;
            fprintf (Out, "\tstrcat(tmp,%s);\n", &v1dp[i + 1]);
            fprintf (Out, "\ti=strlen(tmp);\n");
            fprintf (Out, "\ttmp[i]=%d;\n", k);
            fprintf (Out, "\ttmp[i+1]=0;\n");
            v1dp[j] = k;
            i = j - 1;
            }
      }

  goto no_array1;

no_array:

  if (s1p[spx] == OPENC && pd1[sdlim] == '$'
      && (pd1[sdlim + 1] == 'd' || pd1[sdlim + 1] == 'D')) symflg = SymData;
  else symflg = 1;

  fprintf (Out, "\tif (sym_(%d,\"%s\",tmp%d)==NULL) {;\n", symflg, v1dp, iiitmp);

  strcpy(setname,"\"");
  strcat(setname,v1dp);
  strcat(setname,"\"");

  fprintf (Out, "\t\tprintf(\"\\n*** Variable not found in or near line %%d\\n\\n\",LineNumber);\n");
  fprintf (Out, "\t\tgoto _epilogue;\n");
  fprintf (Out, "\t\t}\n");

no_array1:

  sprintf (&bd[1], "tmp%d", iiitmp);
  iiitmp++;
  memcheck (iiitmp);
  if (pd1[sdlim] != '$') goto exec;

//*=============================
//*	local variable $DATA 
//*=============================

  if (s1p[spx] == OPENC && (pd1[sdlim + 1] == 'd' || pd1[sdlim + 1] == 'D')) {
      symflg = SymData;
      // fprintf(Out,"\tsym_(6,%s,bp);//???\n",v1dp);
      goto exec;
      }

//*===============================================================
//*       process value in bb or bd                               
//*===============================================================

exec:

  if (s1p[spx] != EMPTY && s1p[spx] != OPEN && s1p[spx] != OPENC) goto nxt_expr;

  spx++;
  while (pd1[sdlim++]);
  if (sdlim >= symlen) return (31);

//    deprecated
//	fprintf(Out,"\tstrcpy(tmp%d,%s);\n",iiitmp,bp);
//	sprintf(&pd1[sdlim],"tmp%d",iiitmp);
//	iiitmp++;
//    memcheck(iiitmp);

  strcpy (&pd1[sdlim], bp);

  s1p[spx] = OPERAND;
  goto nchar;

//*===============================================================
//*       process expression - check  for operator on stack top   
//*==============================================================

nxt_expr:

  if (s1p[spx] == OPEN || s1p[spx] == OPERAND) return (11);

//*=============================================================
//*       check for number under operator                       
//*=============================================================

  if (s1p[spx - 1] != OPERAND) {
      switch (s1p[spx]) {

default:

	  return (1);

case INDIRECT:

	  if (kflg) {
	      strcpy (&v1d[1], bp);
	      return (0);
	      }

	  fprintf (Out, "\tstrcpy(xd,%s);\n", bp);
	  fprintf (Out, "\txpx=0;\n");
	  fprintf (Out, "\tt0px=0;\n");
	  fprintf (Out, "\ti=parse_(); \n");
	  fprintf (Out, "\tif (i!=0) {\n");
	  fprintf (Out, "\t\tprintf(\"*** Indirect expression error in or near line %%d\\n\",LineNumber);\n");
	  fprintf (Out, "\t\tgoto _epilogue;\n");
	  fprintf (Out, "\t\t}\n");
	  fprintf (Out, "\tstrcpy(tmp%d,&pd1[sdlim]);\n", iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  break;
	  spx--;
	  strcat (bp, &xd[xpx + 1]);
	  break;
	  strcpy (&xd[1], bp);
	  xpx = 0;
	  goto nchar;
	  break;

case MINUS:		//* unary minus 

	  fprintf (Out, "\tmult(%s,\"-1\",tmp%d);\n", bp, iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  break;

case NOT: //* unary not 

	  fprintf (Out,
		   "\tif (numcomp(%s,\"0\")==0) strcpy(tmp%d,\"1\");\n"
		   "\telse strcpy(tmp%d,\"0\");\n", bp, iiitmp, iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  break;

case PLUS: //* unary plus 

	  fprintf (Out, "\tadd(%s,\"0\",tmp%d);\n", bp, iiitmp);
	  sprintf (bp, "tmp%d", iiitmp);
	  iiitmp++;
	  memcheck (iiitmp);
	  break;

  } //* switch 

      spx--;
      goto nxt_operator;
}

//*=============================
//* extract value under operator 
//*=============================

  for (adx = sdlim--; pd1[sdlim - 1]; sdlim--);

//* branch depending upon operator 

  switch (s1p[spx]) {

case OPERAND:
case EMPTY:
case NOT:
default:

      return (12);

case DIVIDE:

      fprintf (Out, "\tdivx(%s,%s,tmp%d);\n", &pd1[adx], bp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case EXPONEN:

      fprintf (Out, "\texpx(%s,%s,tmp%d);\n", &pd1[adx], bp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case MULTIPLY:

      fprintf (Out, "\tmult(%s,%s,tmp%d);\n", &pd1[adx], bp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case MINUS:

      fprintf (Out, "\tsub(%s,%s,tmp%d);\n", &pd1[adx], bp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case PLUS:

      fprintf (Out, "\tadd(%s,%s,tmp%d);\n", &pd1[adx], bp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case CONCAT:

      fprintf (Out, "\tstrcpy(tmp%d,%s);\n", iiitmp, &pd1[adx]);
      fprintf (Out, "\tstrcat(tmp%d,%s);\n", iiitmp, bp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case EQUALS:
case NOTEQ:

      if (s1p[spx] != NOTEQ) { //* EQUALS 
            fprintf (Out,
                  "\tif (strcmp(%s,%s)==0) strcpy(tmp%d,\"1\");\n"
                  "\telse strcpy(tmp%d,\"0\");\n",
                  &pd1[adx], bp, iiitmp, iiitmp);
            sprintf (bp, "tmp%d", iiitmp);
            iiitmp++;
            memcheck (iiitmp);
            break;
            }

      fprintf (Out, //* NOTEQ 
            "\tif (strcmp(%s,%s)!=0)\n\t\tstrcpy(tmp%d,\"1\");\n"
            "\t\telse strcpy(tmp%d,\"0\");\n",
            &pd1[adx], bp, iiitmp, iiitmp);

      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case GREATER:

      fprintf (Out,
	       "\tif (numcomp(%s,%s)>0) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n", &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case LESSTHAN:

      fprintf (Out,
	       "\tif (numcomp(%s,%s)<0) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n", &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case INTDIVIDE:

      fprintf (Out, "\tdivx(%s,%s,tmp%d);\n", &pd1[adx], bp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      fprintf (Out, "\tfor (i=0; tmp%d[i]; i++)\n", iiitmp);
      fprintf (Out, "\tif (tmp%d[i]==\'.\') { tmp%d[i]=0; break; }\n",
	       iiitmp, iiitmp);
      fprintf (Out, "\tif (tmp%d[0]==0) { tmp%d[0]='0'; tmp%d[1]=0; }\n",
	       iiitmp, iiitmp, iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case MODULO:

      fprintf (Out, "\ti=atoi(%s);\n", bp);
      fprintf (Out, "\t_j=atoi(%s);\n", &pd1[adx]);
      fprintf (Out, "\ti=_j%%i;\n");
      fprintf (Out, "\tltoa(i,tmp%d,10);\n", iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case CONTAINS:

      fprintf (Out,
	       "\tif (xindex(%s,%s,1)>0) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n", &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case FOLLOWS:

      fprintf (Out,
	       "\tif (strcmp(%s,%s)>0) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n", &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case PATTERN:

      fixstr (&bd[1]);
      fprintf (Out,
	       "\tif (pm(%s,\"%s\")) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n",
	       &pd1[adx], &bd[1], iiitmp, iiitmp);
      sprintf (&bd[1], "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case NOTGREATER:

      fprintf (Out,
	       "\tif (numcomp(%s,%s)<=0) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n", &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case NOTLESS:

      fprintf (Out,
	       "\tif (numcomp(%s,%s)>=0) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n", &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case NOTCONTAINS:

      fprintf (Out,
	       "\tif (xindex(%s,%s,1)==0) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n", &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case NOTFOLLOWS:

      fprintf (Out,
	       "\tif (strcmp(%s,%s)<=0) strcpy(tmp%d,\"1\");"
	       " else strcpy(tmp%d,\"0\");\n", &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case NOTPATTERN:

      fixstr (&bd[1]);
      fprintf (Out,
	       "\tif (pm(%s,\"%s\")) strcpy(tmp%d,\"0\");"
	       " else strcpy(tmp%d,\"1\");\n",
	       &pd1[adx], &bd[1], iiitmp, iiitmp);
      sprintf (&bd[1], "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;


case AND:

      fprintf (Out,
	       "\tif (numcomp(%s,\"0\")&&numcomp(%s,\"0\"))"
	       " strcpy(tmp%d,\"1\"); else strcpy(tmp%d,\"0\");\n",
	       &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case OR:

      fprintf (Out,
	       "\tif (numcomp(%s,\"0\")||numcomp(%s,\"0\"))"
	       " strcpy(tmp%d,\"1\"); else strcpy(tmp%d,\"0\");\n",
	       &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case NOTAND:

      fprintf (Out,
	       "\tif (numcomp(%s,\"0\")&&numcomp(%s,\"0\"))"
	       " strcpy(tmp%d,\"0\"); else strcpy(tmp%d,\"1\");\n",
	       &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

case NOTOR:

      fprintf (Out,
	       "\tif (numcomp(%s,\"0\")||numcomp(%s,\"0\"))"
	       " strcpy(tmp%d,\"0\"); else strcpy(tmp%d,\"1\");\n",
	       &pd1[adx], bp, iiitmp, iiitmp);
      sprintf (bp, "tmp%d", iiitmp);
      iiitmp++;
      memcheck (iiitmp);
      break;

    } //* switch 

dec_stk:

  spx -= 2;

nxt_operator:

  if (s1p[spx] != OPEN && 
      s1p[spx] != OPENC && 
      s1p[spx] != EMPTY) goto nxt_expr;

//*===============================================================
//*       push answer                                             
//*===============================================================

  spx++;
  sdlim += strlen (&pd1[sdlim]) + 1;
  if (sdlim >= symlen) return (31);
  strcpy (&pd1[sdlim], bp);
  s1p[spx] = OPERAND;
  goto nchar;

//*===============================================================
//*       exit sequence                                          
//*===============================================================

finish:

  if (s1p[spx - 1] != EMPTY || s1p[spx] != OPERAND) return (16);
  else return (0);
}


//*===============================================================
//*===============================================================
//*===============================================================


void fixstr (unsigned char a[]) {

  char tmp[1024];
  int i, j;

  for (i = 0, j = 0; a[i] != 0; i++) {

      if (a[i] == '\"') {
            tmp[j++] = '\\';
            tmp[j++] = '\"';
            continue;
            }

      if (a[i] == '\'') {
            tmp[j++] = '\\';
            tmp[j++] = '\'';
            continue;
            }

      if (a[i] == '\\') {
            tmp[j++] = '\\';
            tmp[j++] = '\\';
            continue;
            }

      tmp[j++] = a[i];
    }

  tmp[j] = 0;
  strcpy (a, tmp);
  return;
}

#if SYSTEM==DOS

int strcasecmp (char *a, char *b) {

  while (toupper (*a) == toupper (*b) && *a != 0) {
      a++;
      b++;
      }

  if (*a == 0) return 0;
  else return 1;

}

int strncasecmp (char *a, char *b, int i) {

  while (toupper (*a) == toupper (*b) && *a != 0 && i > 0) {
      i--;
      a++;
      b++;
      }

  if (i == 0 || *a == 0) return 0;
  else return 1;

}

#endif

void memcheck (int iiitmp) {

  if (iiitmp > MaxTmp) {
      fprintf (Out, "\tif (tmp%d==NULL) ", iiitmp);
      fprintf (Out, "tmp%d=(unsigned char *)malloc(1024);\n", iiitmp);
      fprintf (Out, "\tif (tmp%d==NULL) { \n", iiitmp);
      fprintf (Out,
	       "\t\tprintf(\"\\n*** Out of memory in or near line %%d\\n\\n\",LineNumber);\n");
      fprintf (Out, "\t\tgoto _epilogue;\n");
      fprintf (Out, "\t\t}\n");
      MaxTmp = iiitmp;
      }
}
